/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.actors.MutabilityTester;
import co.paralleluniverse.concurrent.util.MapUtil;
import co.paralleluniverse.data.record.DynamicGeneratedRecord;
import co.paralleluniverse.data.record.DynamicMethodHandleRecord;
import co.paralleluniverse.data.record.DynamicReflectionRecord;
import co.paralleluniverse.data.record.DynamicUnsafeRecord;
import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordArray;
import co.paralleluniverse.data.record.SealedRecordType;
import co.paralleluniverse.data.record.SimpleRecord;
import co.paralleluniverse.data.record.SimpleRecordArray;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordType<R>
implements SealedRecordType<R> {
    private static final Logger LOG = LoggerFactory.getLogger(RecordType.class);
    private final String name;
    private final RecordType<? super R> parent;
    private final List<Field<? super R, ?>> fields;
    private int fieldIndex;
    private boolean sealed;
    private Set<Field<? super R, ?>> fieldSet;
    private int primitiveIndex;
    private int primitiveOffset;
    private int objectIndex;
    private int objectOffset;
    private int[] offsets;
    private final ThreadLocal<Mode> currentMode = new ThreadLocal();
    private final ClassValue<ClassInfo> vtables;
    private static final ConcurrentMap<String, RecordType<?>> loadedTypes = MapUtil.newConcurrentHashMap();

    public static <R> RecordType<R> newType(Class<R> type, RecordType<? super R> parent) {
        return new RecordType<R>(type, parent);
    }

    public static <R> RecordType<R> newType(Class<R> type) {
        return RecordType.newType(type, null);
    }

    public static RecordType<?> forName(String name) throws ClassNotFoundException {
        return RecordType.forClass(Class.forName(name));
    }

    public static <T> RecordType<T> forClass(Class<T> type) {
        RecordType.sealClassType(type);
        return (RecordType)loadedTypes.get(type.getName());
    }

    private static void sealClassType(Class<?> clazz) {
        java.lang.reflect.Field[] fs = clazz.getDeclaredFields();
        try {
            for (java.lang.reflect.Field f : fs) {
                if (!Modifier.isStatic(f.getModifiers()) || !RecordType.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                ((RecordType)f.get(null)).seal();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addType(String name, RecordType<?> type) {
        block2: {
            RecordType<?> oldType;
            block3: {
                while (true) {
                    if ((oldType = (RecordType<?>)loadedTypes.get(name)) == null) {
                        oldType = loadedTypes.putIfAbsent(name, type);
                        if (oldType != null) continue;
                        break block2;
                    }
                    if (!RecordType.isCompatible(oldType, type)) break block3;
                    if (loadedTypes.replace(name, oldType, type)) break;
                }
                break block2;
            }
            throw new RuntimeException("RecordType " + type + " incompatible with an already loaded type of the same name: " + oldType);
        }
    }

    private static boolean isCompatible(RecordType<?> oldType, RecordType<?> newType) {
        ArrayList oldFields = new ArrayList(oldType.fields());
        ArrayList newFileds = new ArrayList(newType.fields());
        if (newFileds.size() < oldFields.size()) {
            return false;
        }
        for (int i = 0; i < oldFields.size(); ++i) {
            if (((Field)oldFields.get(i)).equals(newFileds.get(i))) continue;
            return false;
        }
        return true;
    }

    public RecordType(Class<R> type, RecordType<? super R> parent) {
        this.name = type.getName().intern();
        this.parent = parent;
        if (parent != null) {
            this.fields = new ArrayList(parent.fields);
            this.fieldIndex = parent.fieldIndex;
            this.primitiveIndex = parent.primitiveIndex;
            this.primitiveOffset = parent.primitiveOffset;
            this.objectIndex = parent.objectIndex;
            this.objectOffset = parent.objectOffset;
        } else {
            this.fields = new ArrayList();
            this.fieldIndex = 0;
        }
        this.vtables = new ClassValue<ClassInfo>(){

            @Override
            protected ClassInfo computeValue(Class<?> type) {
                RecordType.this.seal();
                return new ClassInfo((Mode)((Object)RecordType.this.currentMode.get()), type, RecordType.this);
            }
        };
    }

    public RecordType(Class<R> type) {
        this(type, null);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordType)) {
            return false;
        }
        RecordType other = (RecordType)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.name + this.fields.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Field.BooleanField<R> booleanField(String name) {
        return this.booleanField(name, 0);
    }

    public Field.BooleanField<R> booleanField(String name, int flags) {
        return this.addField(new Field.BooleanField(name, -1, flags));
    }

    public Field.ByteField<R> byteField(String name) {
        return this.byteField(name, 0);
    }

    public Field.ByteField<R> byteField(String name, int flags) {
        return this.addField(new Field.ByteField(name, -1, flags));
    }

    public Field.ShortField<R> shortField(String name) {
        return this.shortField(name, 0);
    }

    public Field.ShortField<R> shortField(String name, int flags) {
        return this.addField(new Field.ShortField(name, -1, flags));
    }

    public Field.IntField<R> intField(String name) {
        return this.intField(name, 0);
    }

    public Field.IntField<R> intField(String name, int flags) {
        return this.addField(new Field.IntField(name, -1, flags));
    }

    public Field.LongField<R> longField(String name) {
        return this.longField(name, 0);
    }

    public Field.LongField<R> longField(String name, int flags) {
        return this.addField(new Field.LongField(name, -1, flags));
    }

    public Field.FloatField<R> floatField(String name) {
        return this.floatField(name, 0);
    }

    public Field.FloatField<R> floatField(String name, int flags) {
        return this.addField(new Field.FloatField(name, -1, flags));
    }

    public Field.DoubleField<R> doubleField(String name) {
        return this.doubleField(name, 0);
    }

    public Field.DoubleField<R> doubleField(String name, int flags) {
        return this.addField(new Field.DoubleField(name, -1, flags));
    }

    public Field.CharField<R> charField(String name) {
        return this.charField(name, 0);
    }

    public Field.CharField<R> charField(String name, int flags) {
        return this.addField(new Field.CharField(name, -1, flags));
    }

    public <V> Field.ObjectField<R, V> objectField(String name, Class<V> type) {
        return this.objectField(name, type, 0);
    }

    public <V> Field.ObjectField<R, V> objectField(String name, Class<V> type, int flags) {
        return this.addField(new Field.ObjectField(name, this.checkMutability(type, name), -1, flags));
    }

    public <V> Field.ObjectField<R, V> objectField(String name, TypeToken<V> type) {
        return this.objectField(name, type, 0);
    }

    public <V> Field.ObjectField<R, V> objectField(String name, TypeToken<V> type, int flags) {
        return this.addField(new Field.ObjectField(name, this.checkMutability(type.getRawType(), name), -1, flags));
    }

    public Field.BooleanArrayField<R> booleanArrayField(String name, int length) {
        return this.booleanArrayField(name, length, 0);
    }

    public Field.BooleanArrayField<R> booleanArrayField(String name, int length, int flags) {
        return this.addField(new Field.BooleanArrayField(name, length, -1, flags));
    }

    public Field.ByteArrayField<R> byteArrayField(String name, int length) {
        return this.byteArrayField(name, length, 0);
    }

    public Field.ByteArrayField<R> byteArrayField(String name, int length, int flags) {
        return this.addField(new Field.ByteArrayField(name, length, -1, flags));
    }

    public Field.ShortArrayField<R> shortArrayField(String name, int length) {
        return this.shortArrayField(name, length, 0);
    }

    public Field.ShortArrayField<R> shortArrayField(String name, int length, int flags) {
        return this.addField(new Field.ShortArrayField(name, length, -1, flags));
    }

    public Field.IntArrayField<R> intArrayField(String name, int length) {
        return this.intArrayField(name, length, 0);
    }

    public Field.IntArrayField<R> intArrayField(String name, int length, int flags) {
        return this.addField(new Field.IntArrayField(name, length, -1, flags));
    }

    public Field.LongArrayField<R> longArrayField(String name, int length) {
        return this.longArrayField(name, length, 0);
    }

    public Field.LongArrayField<R> longArrayField(String name, int length, int flags) {
        return this.addField(new Field.LongArrayField(name, length, -1, flags));
    }

    public Field.FloatArrayField<R> floatArrayField(String name, int length) {
        return this.floatArrayField(name, length, 0);
    }

    public Field.FloatArrayField<R> floatArrayField(String name, int length, int flags) {
        return this.addField(new Field.FloatArrayField(name, length, -1, flags));
    }

    public Field.DoubleArrayField<R> doubleArrayField(String name, int length) {
        return this.doubleArrayField(name, length, 0);
    }

    public Field.DoubleArrayField<R> doubleArrayField(String name, int length, int flags) {
        return this.addField(new Field.DoubleArrayField(name, length, -1, flags));
    }

    public Field.CharArrayField<R> charArrayField(String name, int length) {
        return this.charArrayField(name, length, 0);
    }

    public Field.CharArrayField<R> charArrayField(String name, int length, int flags) {
        return this.addField(new Field.CharArrayField(name, length, -1, flags));
    }

    public <V> Field.ObjectArrayField<R, V> objectArrayField(String name, Class<V> type, int length) {
        return this.objectArrayField(name, type, length, 0);
    }

    public <V> Field.ObjectArrayField<R, V> objectArrayField(String name, Class<V> type, int length, int flags) {
        return this.addField(new Field.ObjectArrayField(name, this.checkMutability(type, name), length, -1, flags));
    }

    private <T> Class<T> checkMutability(Class<T> clazz, String fieldName) {
        if (Record.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        ArrayList<java.lang.reflect.Field> mutableFields = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field f : clazz.getFields()) {
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            mutableFields.add(f);
        }
        Pattern setterPattern = Pattern.compile("set([^a-z].*)?");
        ArrayList<Method> setters = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || !setterPattern.matcher(m.getName()).matches()) continue;
            setters.add(m);
        }
        if (!mutableFields.isEmpty() || !setters.isEmpty()) {
            StringBuilder sb = new StringBuilder("WARNING: Field " + fieldName + " of class " + clazz.getName() + " of record type " + this.name + " appears to be mutable.");
            if (!mutableFields.isEmpty()) {
                sb.append(' ').append("Public non-final fields: ").append(mutableFields).append('.');
            }
            if (!setters.isEmpty()) {
                sb.append(' ').append("Public setters: ").append(setters).append('.');
            }
            LOG.warn(sb.toString());
        }
        MutabilityTester.testMutability(clazz);
        return clazz;
    }

    private <F extends Field<R, ?>> F addField(F field) {
        Field f;
        if (this.sealed) {
            throw new IllegalStateException("Cannot add fields once a record has been instantiated");
        }
        assert (field.id < 0);
        int id = this.fieldIndex++;
        switch (field.type()) {
            case 1: {
                f = Field.booleanField(field.name(), id, field.flags());
                break;
            }
            case 2: {
                f = Field.byteField(field.name(), id, field.flags());
                break;
            }
            case 3: {
                f = Field.shortField(field.name(), id, field.flags());
                break;
            }
            case 4: {
                f = Field.intField(field.name(), id, field.flags());
                break;
            }
            case 5: {
                f = Field.longField(field.name(), id, field.flags());
                break;
            }
            case 6: {
                f = Field.floatField(field.name(), id, field.flags());
                break;
            }
            case 7: {
                f = Field.doubleField(field.name(), id, field.flags());
                break;
            }
            case 8: {
                f = Field.charField(field.name(), id, field.flags());
                break;
            }
            case 11: {
                f = Field.booleanArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 12: {
                f = Field.byteArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 13: {
                f = Field.shortArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 14: {
                f = Field.intArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 15: {
                f = Field.longArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 16: {
                f = Field.floatArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 17: {
                f = Field.doubleArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 18: {
                f = Field.charArrayField(field.name(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            case 9: {
                f = Field.objectField(field.name(), field.typeClass(), id, field.flags());
                break;
            }
            case 19: {
                f = Field.objectArrayField(field.name(), field.typeClass().getComponentType(), ((Field.ArrayField)field).length, id, field.flags());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.fields.add(f);
        return (F)f;
    }

    private void seal() {
        if (!this.sealed) {
            this.sealed = true;
            this.fieldSet = ImmutableSet.copyOf(this.fields);
            this.offsets = new int[this.fields.size()];
            for (Field<R, ?> field : this.fields) {
                int offset;
                if (field.type() == 9 || field.type() == 19) {
                    offset = this.objectOffset;
                    this.objectOffset += field instanceof Field.ArrayField ? ((Field.ArrayField)field).length : 1;
                    ++this.objectIndex;
                } else {
                    offset = this.primitiveOffset;
                    this.primitiveOffset += field.size();
                    ++this.primitiveIndex;
                }
                this.offsets[field.id()] = offset;
            }
            RecordType.addType(this.name, this);
        }
    }

    private static java.lang.reflect.Field getField(Class<?> type, Field field) {
        java.lang.reflect.Field f = null;
        try {
            f = type.getField(field.name());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        try {
            f = type.getDeclaredField(field.name());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (f == null || Modifier.isStatic(f.getModifiers())) {
            return null;
        }
        f.setAccessible(true);
        return f;
    }

    private static Method getGetter(Class<?> type, Field field) {
        Method m = null;
        try {
            m = type.getMethod("get" + RecordType.capitalize(field.name()), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m == null && field.type() == 1) {
            try {
                m = type.getMethod("is" + RecordType.capitalize(field.name()), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (m == null || Modifier.isStatic(m.getModifiers())) {
            return null;
        }
        return m;
    }

    private static Method getSetter(Class<?> type, Field field) {
        Method m = null;
        try {
            m = type.getMethod("set" + RecordType.capitalize(field.name()), field.typeClass());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m == null || Modifier.isStatic(m.getModifiers())) {
            return null;
        }
        return m;
    }

    private static Method getIndexedGetter(Class<?> type, Field field) {
        assert (field instanceof Field.ArrayField);
        Method m = null;
        try {
            m = type.getMethod("get" + RecordType.capitalize(field.name()), Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m == null && field.type() == 11) {
            try {
                m = type.getMethod("is" + RecordType.capitalize(field.name()), Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (m == null || Modifier.isStatic(m.getModifiers())) {
            return null;
        }
        return m;
    }

    private static Method getIndexedSetter(Class<?> type, Field field) {
        assert (field instanceof Field.ArrayField);
        Method m = null;
        try {
            m = type.getMethod("set" + RecordType.capitalize(field.name()), Integer.TYPE, field.typeClass().getComponentType());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m == null || Modifier.isStatic(m.getModifiers())) {
            return null;
        }
        return m;
    }

    private static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public Set<Field<? super R, ?>> fields() {
        this.seal();
        return this.fieldSet;
    }

    ClassInfo getClassInfo(Class<?> clazz) {
        return this.vtables.get(clazz);
    }

    int getPrimitiveIndex() {
        return this.primitiveIndex;
    }

    int getObjectIndex() {
        return this.objectIndex;
    }

    int getPrimitiveOffset() {
        return this.primitiveOffset;
    }

    int getObjectOffset() {
        return this.objectOffset;
    }

    int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public boolean isInstance(Record<?> record) {
        RecordType<? super R> t = (RecordType<? super R>)record.type();
        while (t != null) {
            if (this.equals(t)) {
                return true;
            }
            t = t.parent;
        }
        return false;
    }

    @Override
    public Record<R> newInstance() {
        this.seal();
        return new SimpleRecord(this);
    }

    @Override
    public Record<R> wrap(Object target) {
        return this.wrap(target, null);
    }

    @Override
    public Record<R> wrap(Object target, Mode mode) {
        this.seal();
        this.currentMode.set(mode);
        ClassInfo ci = this.vtables.get(target.getClass());
        if (mode == null) {
            mode = ci.mode;
        }
        if (mode != Mode.REFLECTION && ci.mode != mode) {
            throw new IllegalStateException("Target's class, " + target.getClass().getName() + ", has been mirrored with a different, incompatible mode, " + (Object)((Object)ci.mode));
        }
        switch (mode) {
            case METHOD_HANDLE: {
                return new DynamicMethodHandleRecord(this, target);
            }
            case REFLECTION: {
                return new DynamicReflectionRecord(this, target);
            }
            case UNSAFE: {
                return new DynamicUnsafeRecord(this, target);
            }
            case GENERATION: {
                return new DynamicGeneratedRecord(this, target);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    public RecordArray<R> newArray(int size) {
        this.seal();
        return new SimpleRecordArray(this, size);
    }

    static class Entry {
        final java.lang.reflect.Field field;
        final Method getter;
        final Method setter;
        final MethodHandle getterHandle;
        final MethodHandle setterHandle;
        final boolean readOnly;
        final long offset;
        final DynamicGeneratedRecord.Accessor accessor;
        final boolean indexed;

        public Entry(java.lang.reflect.Field field, Method getter, Method setter, MethodHandle getterHandle, MethodHandle setterHandle, long offset, DynamicGeneratedRecord.Accessor accessor, boolean indexed) {
            this.field = field;
            this.getter = getter;
            this.setter = setter;
            this.getterHandle = getterHandle;
            this.setterHandle = setterHandle;
            this.offset = offset;
            this.accessor = accessor;
            this.indexed = indexed;
            this.readOnly = setter == null && (field == null || !indexed && Modifier.isFinal(field.getModifiers()));
        }
    }

    static class ClassInfo {
        final Entry[] table;
        final Mode mode;
        final Set<Field<?, ?>> fieldSet;

        private ClassInfo(Mode mode, Class<?> type, RecordType<?> recordType) {
            try {
                Set<Field<?, ?>> fields = recordType.fields();
                if (mode == null) {
                    boolean unsafePossible = true;
                    boolean generationPossible = true;
                    for (Field field : fields) {
                        java.lang.reflect.Field f;
                        Method getter = field instanceof Field.ArrayField ? RecordType.getIndexedGetter(type, field) : RecordType.getGetter(type, field);
                        Method setter = field instanceof Field.ArrayField ? RecordType.getIndexedSetter(type, field) : RecordType.getSetter(type, field);
                        java.lang.reflect.Field field2 = f = getter == null ? RecordType.getField(type, field) : null;
                        if (f == null && getter == null) {
                            throw new RuntimeException("Field " + field.name() + " defined in record type " + recordType + " is neither an instance field or a getter of class " + type.getName());
                        }
                        if (f == null && getter != null) {
                            unsafePossible = false;
                        }
                        if (getter != null || (f.getModifiers() & 1) != 0) continue;
                        generationPossible = false;
                    }
                    mode = unsafePossible ? Mode.UNSAFE : (generationPossible ? Mode.GENERATION : Mode.METHOD_HANDLE);
                }
                this.mode = mode;
                this.table = new Entry[fields.size()];
                ArrayList<Field> implementedFields = new ArrayList<Field>();
                for (Field field : fields) {
                    DynamicGeneratedRecord.Accessor accessor;
                    long offset;
                    MethodHandle setterHandle;
                    MethodHandle getterHandle;
                    boolean indexed;
                    Method method = field instanceof Field.ArrayField ? RecordType.getIndexedGetter(type, field) : RecordType.getGetter(type, field);
                    Method setter = field instanceof Field.ArrayField ? RecordType.getIndexedSetter(type, field) : RecordType.getSetter(type, field);
                    java.lang.reflect.Field f = method == null ? RecordType.getField(type, field) : null;
                    boolean bl = indexed = f == null && field instanceof Field.ArrayField;
                    if (mode == Mode.METHOD_HANDLE) {
                        getterHandle = DynamicMethodHandleRecord.getGetterMethodHandle(field, f, method);
                        setterHandle = DynamicMethodHandleRecord.getSetterMethodHandle(field, f, setter);
                    } else {
                        getterHandle = null;
                        setterHandle = null;
                    }
                    if (mode == Mode.UNSAFE) {
                        if (f == null && method != null) {
                            throw new RuntimeException("Cannot use UNSAFE mode for class " + type.getName() + " because field " + field.name + " has a getter and/or a setter");
                        }
                        offset = DynamicUnsafeRecord.getFieldOffset(type, f);
                    } else {
                        offset = -1L;
                    }
                    if (mode == Mode.GENERATION) {
                        if ((type.getModifiers() & 1) == 0) {
                            throw new RuntimeException("Cannot use GENERATION mode because class " + type.getName() + " is not public.");
                        }
                        if (f != null && (f.getModifiers() & 1) == 0) {
                            throw new RuntimeException("Cannot use GENERATION mode because field " + f.getName() + " in class " + type.getName() + " is not public.");
                        }
                        accessor = DynamicGeneratedRecord.generateAccessor(type, field, f, method, setter);
                    } else {
                        accessor = null;
                    }
                    if (f != null || method != null) {
                        implementedFields.add(field);
                    }
                    this.table[field.id()] = new Entry(f, method, setter, getterHandle, setterHandle, offset, accessor, indexed);
                }
                this.fieldSet = ImmutableSet.copyOf(implementedFields);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static enum Mode {
        METHOD_HANDLE,
        REFLECTION,
        UNSAFE,
        GENERATION;

    }
}

