/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.data.record.AbstractRecord;
import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.FieldNotFoundException;
import co.paralleluniverse.data.record.ReadOnlyFieldException;
import co.paralleluniverse.data.record.RecordType;

public abstract class DynamicRecord<R>
extends AbstractRecord<R> {
    private final RecordType.Entry[] vtable;
    final Object obj;

    DynamicRecord(RecordType<R> recordType, Object target) {
        super(recordType);
        RecordType.ClassInfo ci = recordType.getClassInfo(target.getClass());
        this.vtable = ci.table;
        this.obj = target;
    }

    RecordType.Entry entry(Field<? super R, ?> field) {
        try {
            return this.vtable[field.id()];
        }
        catch (IndexOutOfBoundsException e) {
            throw new FieldNotFoundException(field, this.obj);
        }
    }

    void checkReadOnly(RecordType.Entry entry, Field<? super R, ?> field) {
        if (entry.readOnly) {
            throw new ReadOnlyFieldException(field, (Object)this);
        }
    }

    abstract boolean[] get(Field.BooleanArrayField<? super R> var1);

    abstract byte[] get(Field.ByteArrayField<? super R> var1);

    abstract short[] get(Field.ShortArrayField<? super R> var1);

    abstract int[] get(Field.IntArrayField<? super R> var1);

    abstract long[] get(Field.LongArrayField<? super R> var1);

    abstract float[] get(Field.FloatArrayField<? super R> var1);

    abstract double[] get(Field.DoubleArrayField<? super R> var1);

    abstract char[] get(Field.CharArrayField<? super R> var1);

    @Override
    abstract <V> V[] get(Field.ObjectArrayField<? super R, V> var1);
}

