/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.asm.ClassWriter;
import co.paralleluniverse.asm.MethodVisitor;
import co.paralleluniverse.asm.Type;
import co.paralleluniverse.data.record.DynamicRecord;
import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.ReadOnlyFieldException;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class DynamicGeneratedRecord<R>
extends DynamicRecord<R> {
    private static final String DYNAMIC_GENERATED_RECORD_TYPE = Type.getInternalName(DynamicGeneratedRecord.class);
    private static final ClassValue<MyClassLoader> myClassLoader = new ClassValue<MyClassLoader>(){

        @Override
        protected MyClassLoader computeValue(Class<?> type) {
            return new MyClassLoader(type.getClassLoader());
        }
    };

    static Accessor generateAccessor(Class<?> type, Field<?, ?> field, java.lang.reflect.Field f, Method getter, Method setter) {
        Class<?> accessorClass;
        MyClassLoader cl = myClassLoader.get(type);
        String className = DynamicGeneratedRecord.accessorClassName(type, field);
        try {
            accessorClass = Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            byte[] classData = field instanceof Field.ArrayField ? (f != null ? DynamicGeneratedRecord.generateArrayFieldAccessor(type, field, f) : DynamicGeneratedRecord.generateIndexedAccessor(type, field, getter, setter)) : (f != null ? DynamicGeneratedRecord.generateSimpleFieldAccessor(type, field, f) : DynamicGeneratedRecord.generateMethodAccessor(type, field, getter, setter));
            accessorClass = cl.defineClass(className, classData);
        }
        try {
            Accessor accessor = (Accessor)accessorClass.newInstance();
            return accessor;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String accessorClassName(Class<?> type, Field<?, ?> field) {
        String packageName = DynamicGeneratedRecord.class.getPackage().getName();
        String className = type.getSimpleName() + "$" + field.name() + "Accessor$" + Integer.toHexString(type.hashCode());
        return packageName + "." + className;
    }

    private static ClassWriter generateClass(Class<?> type, Field field, String accName) {
        String superName = DYNAMIC_GENERATED_RECORD_TYPE + "$" + accName;
        String className = DynamicGeneratedRecord.accessorClassName(type, field).replace('.', '/');
        ClassWriter cw = new ClassWriter(1);
        cw.visit(51, 33, className, null, superName, null);
        cw.visitInnerClass(superName, DYNAMIC_GENERATED_RECORD_TYPE, accName, 1032);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superName, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        return cw;
    }

    private static String methodSigTypeDesc(Field<?, ?> field) {
        if (field instanceof Field.ObjectField) {
            return "Ljava/lang/Object;";
        }
        if (field instanceof Field.ObjectArrayField) {
            return "[Ljava/lang/Object;";
        }
        return Type.getDescriptor(field.typeClass());
    }

    private static String methodSigComponentTypeDesc(Field<?, ?> field) {
        assert (field instanceof Field.ArrayField);
        if (field instanceof Field.ObjectArrayField) {
            return "Ljava/lang/Object;";
        }
        return Type.getDescriptor(field.typeClass().getComponentType());
    }

    private static byte[] generateSimpleFieldAccessor(Class<?> type, Field<?, ?> field, java.lang.reflect.Field f) {
        String typeName = Type.getInternalName(type);
        String fieldTypeName = Type.getInternalName(field.typeClass());
        String fieldTypeDesc = Type.getDescriptor(field.typeClass());
        String accName = DynamicGeneratedRecord.accessorName(field) + "Accessor";
        ClassWriter cw = DynamicGeneratedRecord.generateClass(type, field, accName);
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;)" + DynamicGeneratedRecord.methodSigTypeDesc(field), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, typeName);
        mv.visitFieldInsn(180, typeName, field.name(), fieldTypeDesc);
        mv.visitInsn(DynamicGeneratedRecord.returnOpcode(field));
        mv.visitEnd();
        mv = cw.visitMethod(1, "set", "(Ljava/lang/Object;" + DynamicGeneratedRecord.methodSigTypeDesc(field) + ")V", null, null);
        mv.visitCode();
        if (Modifier.isFinal(f.getModifiers())) {
            mv.visitTypeInsn(187, "co/paralleluniverse/data/record/ReadOnlyFieldException");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "co/paralleluniverse/data/record/ReadOnlyFieldException", "<init>", "()V", false);
            mv.visitInsn(191);
        } else {
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, typeName);
            mv.visitVarInsn(DynamicGeneratedRecord.loadOpcode(field), 2);
            if (field instanceof Field.ObjectField) {
                mv.visitTypeInsn(192, fieldTypeName);
            }
            mv.visitFieldInsn(181, typeName, field.name(), fieldTypeDesc);
            mv.visitInsn(177);
        }
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] generateMethodAccessor(Class<?> type, Field<?, ?> field, Method getter, Method setter) {
        String typeName = Type.getInternalName(type);
        String fieldTypeName = Type.getInternalName(field.typeClass());
        String fieldTypeDesc = Type.getDescriptor(field.typeClass());
        String accName = DynamicGeneratedRecord.accessorName(field) + "Accessor";
        ClassWriter cw = DynamicGeneratedRecord.generateClass(type, field, accName);
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;)" + DynamicGeneratedRecord.methodSigTypeDesc(field), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, typeName);
        mv.visitMethodInsn(182, typeName, getter.getName(), Type.getMethodDescriptor((Method)getter), false);
        mv.visitInsn(DynamicGeneratedRecord.returnOpcode(field));
        mv.visitEnd();
        mv = cw.visitMethod(1, "set", "(Ljava/lang/Object;" + DynamicGeneratedRecord.methodSigTypeDesc(field) + ")V", null, null);
        mv.visitCode();
        if (setter != null) {
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, typeName);
            mv.visitVarInsn(DynamicGeneratedRecord.loadOpcode(field), 2);
            if (field instanceof Field.ObjectField) {
                mv.visitTypeInsn(192, fieldTypeName);
            }
            mv.visitMethodInsn(182, typeName, setter.getName(), Type.getMethodDescriptor((Method)setter), false);
            mv.visitInsn(177);
        } else {
            mv.visitTypeInsn(187, Type.getInternalName(ReadOnlyFieldException.class));
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)field.name);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, Type.getInternalName(ReadOnlyFieldException.class), "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", false);
            mv.visitInsn(191);
        }
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] generateArrayFieldAccessor(Class<?> type, Field<?, ?> field, java.lang.reflect.Field f) {
        String typeName = Type.getInternalName(type);
        String typeDesc = Type.getDescriptor(field.typeClass());
        String accName = DynamicGeneratedRecord.accessorName(field) + "ArrayAccessor";
        ClassWriter cw = DynamicGeneratedRecord.generateClass(type, field, accName);
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;)" + DynamicGeneratedRecord.methodSigTypeDesc(field), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, typeName);
        mv.visitFieldInsn(180, typeName, field.name(), typeDesc);
        mv.visitInsn(176);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] generateIndexedAccessor(Class<?> type, Field<?, ?> field, Method getter, Method setter) {
        String typeName = Type.getInternalName(type);
        String fieldComponentTypeName = Type.getInternalName(field.typeClass().getComponentType());
        String fieldTypeDesc = Type.getDescriptor(field.typeClass());
        String accName = DynamicGeneratedRecord.accessorName(field) + "IndexedAccessor";
        ClassWriter cw = DynamicGeneratedRecord.generateClass(type, field, accName);
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;I)" + DynamicGeneratedRecord.methodSigComponentTypeDesc(field), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, typeName);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(182, typeName, getter.getName(), Type.getMethodDescriptor((Method)getter), false);
        mv.visitInsn(DynamicGeneratedRecord.returnOpcode(field));
        mv.visitEnd();
        mv = cw.visitMethod(1, "set", "(Ljava/lang/Object;I" + DynamicGeneratedRecord.methodSigComponentTypeDesc(field) + ")V", null, null);
        mv.visitCode();
        if (setter != null) {
            mv.visitVarInsn(25, 1);
            mv.visitTypeInsn(192, typeName);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(DynamicGeneratedRecord.loadOpcode(field), 3);
            if (field instanceof Field.ObjectArrayField) {
                mv.visitTypeInsn(192, fieldComponentTypeName);
            }
            mv.visitMethodInsn(182, typeName, setter.getName(), Type.getMethodDescriptor((Method)setter), false);
            mv.visitInsn(177);
        } else {
            mv.visitTypeInsn(187, Type.getInternalName(ReadOnlyFieldException.class));
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)field.name);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, Type.getInternalName(ReadOnlyFieldException.class), "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", false);
            mv.visitInsn(191);
        }
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static String accessorName(Field field) {
        switch (field.type()) {
            case 1: 
            case 11: {
                return "Boolean";
            }
            case 2: 
            case 12: {
                return "Byte";
            }
            case 3: 
            case 13: {
                return "Short";
            }
            case 4: 
            case 14: {
                return "Int";
            }
            case 5: 
            case 15: {
                return "Long";
            }
            case 6: 
            case 16: {
                return "Float";
            }
            case 7: 
            case 17: {
                return "Double";
            }
            case 8: 
            case 18: {
                return "Char";
            }
            case 9: 
            case 19: {
                return "Object";
            }
        }
        throw new AssertionError();
    }

    private static int returnOpcode(Field field) {
        switch (field.type()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                return 172;
            }
            case 5: 
            case 15: {
                return 173;
            }
            case 6: 
            case 16: {
                return 174;
            }
            case 7: 
            case 17: {
                return 175;
            }
            case 9: 
            case 19: {
                return 176;
            }
        }
        throw new AssertionError();
    }

    private static int loadOpcode(Field field) {
        switch (field.type()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                return 21;
            }
            case 5: 
            case 15: {
                return 22;
            }
            case 6: 
            case 16: {
                return 23;
            }
            case 7: 
            case 17: {
                return 24;
            }
            case 9: 
            case 19: {
                return 25;
            }
        }
        throw new AssertionError();
    }

    DynamicGeneratedRecord(RecordType<R> recordType, Object target) {
        super(recordType, target);
    }

    @Override
    public boolean get(Field.BooleanField<? super R> field) {
        return ((BooleanAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.BooleanField<? super R> field, boolean value) {
        ((BooleanAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public byte get(Field.ByteField<? super R> field) {
        return ((ByteAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.ByteField<? super R> field, byte value) {
        ((ByteAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public short get(Field.ShortField<? super R> field) {
        return ((ShortAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.ShortField<? super R> field, short value) {
        ((ShortAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public int get(Field.IntField<? super R> field) {
        return ((IntAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.IntField<? super R> field, int value) {
        ((IntAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public long get(Field.LongField<? super R> field) {
        return ((LongAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.LongField<? super R> field, long value) {
        ((LongAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public float get(Field.FloatField<? super R> field) {
        return ((FloatAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.FloatField<? super R> field, float value) {
        ((FloatAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public double get(Field.DoubleField<? super R> field) {
        return ((DoubleAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.DoubleField<? super R> field, double value) {
        ((DoubleAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public char get(Field.CharField<? super R> field) {
        return ((CharAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public void set(Field.CharField<? super R> field, char value) {
        ((CharAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    public <V> V get(Field.ObjectField<? super R, V> field) {
        return (V)((ObjectAccessor)this.entry(field).accessor).get(this.obj);
    }

    @Override
    public <V> void set(Field.ObjectField<? super R, V> field, V value) {
        ((ObjectAccessor)this.entry(field).accessor).set(this.obj, value);
    }

    @Override
    boolean[] get(Field.BooleanArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((BooleanArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public boolean get(Field.BooleanArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((BooleanIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((BooleanArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, int index, boolean value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((BooleanIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((BooleanArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.BooleanArrayField<? super R> field, boolean[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            BooleanIndexedAccessor accessor = (BooleanIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((BooleanArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, boolean[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            BooleanIndexedAccessor accessor = (BooleanIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((BooleanArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.BooleanArrayField<? super R> field, Record<S> source, Field.BooleanArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            BooleanIndexedAccessor accessor = (BooleanIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((BooleanArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    byte[] get(Field.ByteArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((ByteArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public byte get(Field.ByteArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((ByteIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((ByteArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, int index, byte value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((ByteIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((ByteArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.ByteArrayField<? super R> field, byte[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ByteIndexedAccessor accessor = (ByteIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((ByteArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, byte[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ByteIndexedAccessor accessor = (ByteIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((ByteArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.ByteArrayField<? super R> field, Record<S> source, Field.ByteArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ByteIndexedAccessor accessor = (ByteIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((ByteArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    short[] get(Field.ShortArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((ShortArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public short get(Field.ShortArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((ShortIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((ShortArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, int index, short value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((ShortIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((ShortArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.ShortArrayField<? super R> field, short[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ShortIndexedAccessor accessor = (ShortIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((ShortArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, short[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ShortIndexedAccessor accessor = (ShortIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((ShortArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.ShortArrayField<? super R> field, Record<S> source, Field.ShortArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ShortIndexedAccessor accessor = (ShortIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((ShortArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    int[] get(Field.IntArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((IntArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public int get(Field.IntArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((IntIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((IntArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int index, int value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((IntIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((IntArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.IntArrayField<? super R> field, int[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            IntIndexedAccessor accessor = (IntIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((IntArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            IntIndexedAccessor accessor = (IntIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((IntArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.IntArrayField<? super R> field, Record<S> source, Field.IntArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            IntIndexedAccessor accessor = (IntIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((IntArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    long[] get(Field.LongArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((LongArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public long get(Field.LongArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((LongIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((LongArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, int index, long value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((LongIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((LongArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.LongArrayField<? super R> field, long[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            LongIndexedAccessor accessor = (LongIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((LongArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, long[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            LongIndexedAccessor accessor = (LongIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((LongArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.LongArrayField<? super R> field, Record<S> source, Field.LongArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            LongIndexedAccessor accessor = (LongIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((LongArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    float[] get(Field.FloatArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((FloatArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public float get(Field.FloatArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((FloatIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((FloatArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, int index, float value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((FloatIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((FloatArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.FloatArrayField<? super R> field, float[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            FloatIndexedAccessor accessor = (FloatIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((FloatArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, float[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            FloatIndexedAccessor accessor = (FloatIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((FloatArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.FloatArrayField<? super R> field, Record<S> source, Field.FloatArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            FloatIndexedAccessor accessor = (FloatIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((FloatArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    double[] get(Field.DoubleArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((DoubleArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public double get(Field.DoubleArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((DoubleIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((DoubleArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, int index, double value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((DoubleIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((DoubleArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.DoubleArrayField<? super R> field, double[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            DoubleIndexedAccessor accessor = (DoubleIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((DoubleArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, double[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            DoubleIndexedAccessor accessor = (DoubleIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((DoubleArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.DoubleArrayField<? super R> field, Record<S> source, Field.DoubleArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            DoubleIndexedAccessor accessor = (DoubleIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((DoubleArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    char[] get(Field.CharArrayField<? super R> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((CharArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public char get(Field.CharArrayField<? super R> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return ((CharIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return ((CharArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, int index, char value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((CharIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((CharArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public void get(Field.CharArrayField<? super R> field, char[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            CharIndexedAccessor accessor = (CharIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((CharArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, char[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            CharIndexedAccessor accessor = (CharIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((CharArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S> void set(Field.CharArrayField<? super R> field, Record<S> source, Field.CharArrayField<? super S> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            CharIndexedAccessor accessor = (CharIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((CharArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    @Override
    <V> V[] get(Field.ObjectArrayField<? super R, V> field) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return null;
        }
        return ((ObjectArrayAccessor)entry.accessor).get(this.obj);
    }

    @Override
    public <V> V get(Field.ObjectArrayField<? super R, V> field, int index) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            return (V)((ObjectIndexedAccessor)entry.accessor).get(this.obj, index);
        }
        return (V)((ObjectArrayAccessor)entry.accessor).get(this.obj)[index];
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, int index, V value) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ((ObjectIndexedAccessor)entry.accessor).set(this.obj, index, value);
        } else {
            ((ObjectArrayAccessor)entry.accessor).get((Object)this.obj)[index] = value;
        }
    }

    @Override
    public <V> void get(Field.ObjectArrayField<? super R, V> field, V[] target, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ObjectIndexedAccessor accessor = (ObjectIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                target[offset + i] = accessor.get(this.obj, i);
            }
        } else {
            System.arraycopy(((ObjectArrayAccessor)entry.accessor).get(this.obj), 0, target, offset, field.length);
        }
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, V[] source, int offset) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ObjectIndexedAccessor accessor = (ObjectIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source[offset + i]);
            }
        } else {
            System.arraycopy(source, offset, ((ObjectArrayAccessor)entry.accessor).get(this.obj), 0, field.length);
        }
    }

    @Override
    public <S, V> void set(Field.ObjectArrayField<? super R, V> field, Record<S> source, Field.ObjectArrayField<? super S, V> sourceField) {
        RecordType.Entry entry = this.entry(field);
        if (entry.indexed) {
            ObjectIndexedAccessor accessor = (ObjectIndexedAccessor)entry.accessor;
            for (int i = 0; i < field.length; ++i) {
                accessor.set(this.obj, i, source.get(sourceField, i));
            }
        } else {
            source.get(sourceField, ((ObjectArrayAccessor)entry.accessor).get(this.obj), 0);
        }
    }

    public static abstract class ObjectIndexedAccessor
    extends Accessor {
        public abstract Object get(Object var1, int var2);

        public abstract void set(Object var1, int var2, Object var3);
    }

    public static abstract class ObjectArrayAccessor
    extends Accessor {
        public abstract Object[] get(Object var1);
    }

    public static abstract class ObjectAccessor
    extends Accessor {
        public abstract Object get(Object var1);

        public abstract void set(Object var1, Object var2);
    }

    public static abstract class CharIndexedAccessor
    extends Accessor {
        public abstract char get(Object var1, int var2);

        public abstract void set(Object var1, int var2, char var3);
    }

    public static abstract class CharArrayAccessor
    extends Accessor {
        public abstract char[] get(Object var1);
    }

    public static abstract class CharAccessor
    extends Accessor {
        public abstract char get(Object var1);

        public abstract void set(Object var1, char var2);
    }

    public static abstract class DoubleIndexedAccessor
    extends Accessor {
        public abstract double get(Object var1, int var2);

        public abstract void set(Object var1, int var2, double var3);
    }

    public static abstract class DoubleArrayAccessor
    extends Accessor {
        public abstract double[] get(Object var1);
    }

    public static abstract class DoubleAccessor
    extends Accessor {
        public abstract double get(Object var1);

        public abstract void set(Object var1, double var2);
    }

    public static abstract class FloatIndexedAccessor
    extends Accessor {
        public abstract float get(Object var1, int var2);

        public abstract void set(Object var1, int var2, float var3);
    }

    public static abstract class FloatArrayAccessor
    extends Accessor {
        public abstract float[] get(Object var1);
    }

    public static abstract class FloatAccessor
    extends Accessor {
        public abstract float get(Object var1);

        public abstract void set(Object var1, float var2);
    }

    public static abstract class LongIndexedAccessor
    extends Accessor {
        public abstract long get(Object var1, int var2);

        public abstract void set(Object var1, int var2, long var3);
    }

    public static abstract class LongArrayAccessor
    extends Accessor {
        public abstract long[] get(Object var1);
    }

    public static abstract class LongAccessor
    extends Accessor {
        public abstract long get(Object var1);

        public abstract void set(Object var1, long var2);
    }

    public static abstract class IntIndexedAccessor
    extends Accessor {
        public abstract int get(Object var1, int var2);

        public abstract void set(Object var1, int var2, int var3);
    }

    public static abstract class IntArrayAccessor
    extends Accessor {
        public abstract int[] get(Object var1);
    }

    public static abstract class IntAccessor
    extends Accessor {
        public abstract int get(Object var1);

        public abstract void set(Object var1, int var2);
    }

    public static abstract class ShortIndexedAccessor
    extends Accessor {
        public abstract short get(Object var1, int var2);

        public abstract void set(Object var1, int var2, short var3);
    }

    public static abstract class ShortArrayAccessor
    extends Accessor {
        public abstract short[] get(Object var1);
    }

    public static abstract class ShortAccessor
    extends Accessor {
        public abstract short get(Object var1);

        public abstract void set(Object var1, short var2);
    }

    public static abstract class ByteIndexedAccessor
    extends Accessor {
        public abstract byte get(Object var1, int var2);

        public abstract void set(Object var1, int var2, byte var3);
    }

    public static abstract class ByteArrayAccessor
    extends Accessor {
        public abstract byte[] get(Object var1);
    }

    public static abstract class ByteAccessor
    extends Accessor {
        public abstract byte get(Object var1);

        public abstract void set(Object var1, byte var2);
    }

    public static abstract class BooleanIndexedAccessor
    extends Accessor {
        public abstract boolean get(Object var1, int var2);

        public abstract void set(Object var1, int var2, boolean var3);
    }

    public static abstract class BooleanArrayAccessor
    extends Accessor {
        public abstract boolean[] get(Object var1);
    }

    public static abstract class BooleanAccessor
    extends Accessor {
        public abstract boolean get(Object var1);

        public abstract void set(Object var1, boolean var2);
    }

    public static abstract class Accessor {
    }

    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

