/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.data.record;

import co.paralleluniverse.common.util.DelegatingEquals;
import co.paralleluniverse.data.record.Field;
import co.paralleluniverse.data.record.FieldNotFoundException;
import co.paralleluniverse.data.record.ReadOnlyFieldException;
import co.paralleluniverse.data.record.Record;
import co.paralleluniverse.data.record.RecordType;
import co.paralleluniverse.data.record.SealedRecordType;
import co.paralleluniverse.data.record.SerializedRecord;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Set;

public abstract class AbstractRecord<R>
implements Record<R>,
Serializable {
    public final RecordType<R> type;

    protected AbstractRecord(RecordType<R> type) {
        this.type = type;
    }

    @Override
    public SealedRecordType<R> type() {
        return this.type;
    }

    @Override
    public Set<Field<? super R, ?>> fields() {
        return this.type.fields();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj instanceof DelegatingEquals ? obj.equals(this) : obj == this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Record@").append(Integer.toHexString(System.identityHashCode(this))).append('{');
        for (Field<R, ?> field : this.fields()) {
            sb.append(field.name).append(": ");
            switch (field.type()) {
                case 1: {
                    sb.append(this.get((Field.BooleanField)field));
                    break;
                }
                case 2: {
                    sb.append(this.get((Field.ByteField)field));
                    break;
                }
                case 3: {
                    sb.append(this.get((Field.ShortField)field));
                    break;
                }
                case 4: {
                    sb.append(this.get((Field.IntField)field));
                    break;
                }
                case 5: {
                    sb.append(this.get((Field.LongField)field));
                    break;
                }
                case 6: {
                    sb.append(this.get((Field.FloatField)field));
                    break;
                }
                case 7: {
                    sb.append(this.get((Field.DoubleField)field));
                    break;
                }
                case 8: {
                    sb.append(this.get((Field.CharField)field));
                    break;
                }
                case 9: {
                    sb.append(this.get((Field.ObjectField)field));
                    break;
                }
                case 11: {
                    int i;
                    Field.ArrayField f = (Field.BooleanArrayField)field;
                    sb.append('[');
                    if (f.length > 0) {
                        for (i = 0; i < f.length; ++i) {
                            sb.append(this.get((Field.BooleanArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 12: {
                    int i;
                    Field.ArrayField f = (Field.ByteArrayField)field;
                    sb.append('[');
                    if (((Field.ByteArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.ByteArrayField)f).length; ++i) {
                            sb.append(this.get((Field.ByteArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 13: {
                    int i;
                    Field.ArrayField f = (Field.ShortArrayField)field;
                    sb.append('[');
                    if (((Field.ShortArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.ShortArrayField)f).length; ++i) {
                            sb.append(this.get((Field.ShortArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 14: {
                    int i;
                    Field.ArrayField f = (Field.IntArrayField)field;
                    sb.append('[');
                    if (((Field.IntArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.IntArrayField)f).length; ++i) {
                            sb.append(this.get((Field.IntArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 15: {
                    int i;
                    Field.ArrayField f = (Field.LongArrayField)field;
                    sb.append('[');
                    if (((Field.LongArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.LongArrayField)f).length; ++i) {
                            sb.append(this.get((Field.LongArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 16: {
                    int i;
                    Field.ArrayField f = (Field.FloatArrayField)field;
                    sb.append('[');
                    if (((Field.FloatArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.FloatArrayField)f).length; ++i) {
                            sb.append(this.get((Field.FloatArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 17: {
                    int i;
                    Field.ArrayField f = (Field.DoubleArrayField)field;
                    sb.append('[');
                    if (((Field.DoubleArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.DoubleArrayField)f).length; ++i) {
                            sb.append(this.get((Field.DoubleArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 18: {
                    int i;
                    Field.ArrayField f = (Field.CharArrayField)field;
                    sb.append('[');
                    if (((Field.CharArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.CharArrayField)f).length; ++i) {
                            sb.append(this.get((Field.CharArrayField<? super R>)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                case 19: {
                    int i;
                    Field.ArrayField f = (Field.ObjectArrayField)field;
                    sb.append('[');
                    if (((Field.ObjectArrayField)f).length > 0) {
                        for (i = 0; i < ((Field.ObjectArrayField)f).length; ++i) {
                            sb.append(this.get((Field.ObjectArrayField)f, i)).append(", ");
                        }
                        sb.delete(sb.length() - 2, sb.length());
                    }
                    sb.append(']');
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            sb.append(", ");
        }
        if (this.fields().size() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void write(ObjectOutput out) throws IOException {
        block20: for (Field<R, ?> field : this.fields()) {
            if (field.isTransient()) continue;
            switch (field.type()) {
                case 1: {
                    out.writeBoolean(this.get((Field.BooleanField)field));
                    break;
                }
                case 2: {
                    out.writeByte(this.get((Field.ByteField)field));
                    break;
                }
                case 3: {
                    out.writeShort(this.get((Field.ShortField)field));
                    break;
                }
                case 4: {
                    out.writeInt(this.get((Field.IntField)field));
                    break;
                }
                case 5: {
                    out.writeLong(this.get((Field.LongField)field));
                    break;
                }
                case 6: {
                    out.writeFloat(this.get((Field.FloatField)field));
                    break;
                }
                case 7: {
                    out.writeDouble(this.get((Field.DoubleField)field));
                    break;
                }
                case 8: {
                    out.writeChar(this.get((Field.CharField)field));
                    break;
                }
                case 9: {
                    out.writeObject(this.get((Field.ObjectField)field));
                    break;
                }
                case 11: {
                    int i;
                    Field.ArrayField f = (Field.BooleanArrayField)field;
                    if (f.length <= 0) continue block20;
                    for (i = 0; i < f.length; ++i) {
                        out.writeBoolean(this.get((Field.BooleanArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 12: {
                    int i;
                    Field.ArrayField f = (Field.ByteArrayField)field;
                    if (((Field.ByteArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.ByteArrayField)f).length; ++i) {
                        out.writeByte(this.get((Field.ByteArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 13: {
                    int i;
                    Field.ArrayField f = (Field.ShortArrayField)field;
                    if (((Field.ShortArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.ShortArrayField)f).length; ++i) {
                        out.writeShort(this.get((Field.ShortArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 14: {
                    int i;
                    Field.ArrayField f = (Field.IntArrayField)field;
                    if (((Field.IntArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.IntArrayField)f).length; ++i) {
                        out.writeInt(this.get((Field.IntArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 15: {
                    int i;
                    Field.ArrayField f = (Field.LongArrayField)field;
                    if (((Field.LongArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.LongArrayField)f).length; ++i) {
                        out.writeLong(this.get((Field.LongArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 16: {
                    int i;
                    Field.ArrayField f = (Field.FloatArrayField)field;
                    if (((Field.FloatArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.FloatArrayField)f).length; ++i) {
                        out.writeFloat(this.get((Field.FloatArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 17: {
                    int i;
                    Field.ArrayField f = (Field.DoubleArrayField)field;
                    if (((Field.DoubleArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.DoubleArrayField)f).length; ++i) {
                        out.writeDouble(this.get((Field.DoubleArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 18: {
                    int i;
                    Field.ArrayField f = (Field.CharArrayField)field;
                    if (((Field.CharArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.CharArrayField)f).length; ++i) {
                        out.writeChar(this.get((Field.CharArrayField<? super R>)f, i));
                    }
                    continue block20;
                }
                case 19: {
                    int i;
                    Field.ArrayField f = (Field.ObjectArrayField)field;
                    if (((Field.ObjectArrayField)f).length <= 0) continue block20;
                    for (i = 0; i < ((Field.ObjectArrayField)f).length; ++i) {
                        out.writeObject(this.get((Field.ObjectArrayField)f, i));
                    }
                    continue block20;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public void read(ObjectInput in) throws IOException {
        this.read(in, this.fields().size());
    }

    @Override
    public void read(ObjectInput in, int numFields) throws IOException {
        try {
            int k = 0;
            block22: for (Field<R, ?> field : this.fields()) {
                if (k != numFields) {
                    ++k;
                    if (field.isTransient()) continue;
                    switch (field.type()) {
                        case 1: {
                            this.set((Field.BooleanField)field, in.readBoolean());
                            break;
                        }
                        case 2: {
                            this.set((Field.ByteField)field, in.readByte());
                            break;
                        }
                        case 3: {
                            this.set((Field.ShortField)field, in.readShort());
                            break;
                        }
                        case 4: {
                            this.set((Field.IntField)field, in.readInt());
                            break;
                        }
                        case 5: {
                            this.set((Field.LongField)field, in.readLong());
                            break;
                        }
                        case 6: {
                            this.set((Field.FloatField)field, in.readFloat());
                            break;
                        }
                        case 7: {
                            this.set((Field.DoubleField)field, in.readDouble());
                            break;
                        }
                        case 8: {
                            this.set((Field.CharField)field, in.readChar());
                            break;
                        }
                        case 9: {
                            this.set((Field.ObjectField)field, in.readObject());
                            break;
                        }
                        case 11: {
                            int i;
                            Field.ArrayField f = (Field.BooleanArrayField)field;
                            if (f.length <= 0) continue block22;
                            for (i = 0; i < f.length; ++i) {
                                this.set((Field.BooleanArrayField<? super R>)f, i, in.readBoolean());
                            }
                            continue block22;
                        }
                        case 12: {
                            int i;
                            Field.ArrayField f = (Field.ByteArrayField)field;
                            if (((Field.ByteArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.ByteArrayField)f).length; ++i) {
                                this.set((Field.ByteArrayField<? super R>)f, i, in.readByte());
                            }
                            continue block22;
                        }
                        case 13: {
                            int i;
                            Field.ArrayField f = (Field.ShortArrayField)field;
                            if (((Field.ShortArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.ShortArrayField)f).length; ++i) {
                                this.set((Field.ShortArrayField<? super R>)f, i, in.readShort());
                            }
                            continue block22;
                        }
                        case 14: {
                            int i;
                            Field.ArrayField f = (Field.IntArrayField)field;
                            if (((Field.IntArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.IntArrayField)f).length; ++i) {
                                this.set((Field.IntArrayField<? super R>)f, i, in.readInt());
                            }
                            continue block22;
                        }
                        case 15: {
                            int i;
                            Field.ArrayField f = (Field.LongArrayField)field;
                            if (((Field.LongArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.LongArrayField)f).length; ++i) {
                                this.set((Field.LongArrayField<? super R>)f, i, in.readLong());
                            }
                            continue block22;
                        }
                        case 16: {
                            int i;
                            Field.ArrayField f = (Field.FloatArrayField)field;
                            if (((Field.FloatArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.FloatArrayField)f).length; ++i) {
                                this.set((Field.FloatArrayField<? super R>)f, i, in.readFloat());
                            }
                            continue block22;
                        }
                        case 17: {
                            int i;
                            Field.ArrayField f = (Field.DoubleArrayField)field;
                            if (((Field.DoubleArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.DoubleArrayField)f).length; ++i) {
                                this.set((Field.DoubleArrayField<? super R>)f, i, in.readDouble());
                            }
                            continue block22;
                        }
                        case 18: {
                            int i;
                            Field.ArrayField f = (Field.CharArrayField)field;
                            if (((Field.CharArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.CharArrayField)f).length; ++i) {
                                this.set((Field.CharArrayField<? super R>)f, i, in.readChar());
                            }
                            continue block22;
                        }
                        case 19: {
                            int i;
                            Field.ArrayField f = (Field.ObjectArrayField)field;
                            if (((Field.ObjectArrayField)f).length <= 0) continue block22;
                            for (i = 0; i < ((Field.ObjectArrayField)f).length; ++i) {
                                this.set((Field.ObjectArrayField)f, i, (Object)in.readObject());
                            }
                            continue block22;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerializedRecord(this);
    }

    @Override
    public <V> V get(Field<? super R, V> field) {
        return field.get(this);
    }

    @Override
    public <V> void set(Field<? super R, V> field, V value) {
        field.set(this, value);
    }

    @Override
    public <V> V get(Field.ArrayField<? super R, V> field, int index) {
        return field.get(this, index);
    }

    @Override
    public <V> void set(Field.ArrayField<? super R, V> field, int index, V value) {
        field.set(this, index, value);
    }

    @Override
    public <V> void get(Field.ArrayField<? super R, V> field, V[] target, int offset) {
        field.get(this, target, offset);
    }

    @Override
    public <V> void set(Field.ArrayField<? super R, V> field, V[] source, int offset) {
        field.set(this, source, offset);
    }

    @Override
    public <S, V> void set(Field.ArrayField<? super R, V> field, Record<S> source, Field.ArrayField<? super S, V> sourceField) {
        field.set((Record<R>)this, sourceField.get(source));
    }

    @Override
    public boolean get(Field.BooleanField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.BooleanField<? super R> field, boolean value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public byte get(Field.ByteField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.ByteField<? super R> field, byte value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public short get(Field.ShortField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.ShortField<? super R> field, short value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public int get(Field.IntField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.IntField<? super R> field, int value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public long get(Field.LongField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.LongField<? super R> field, long value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public float get(Field.FloatField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.FloatField<? super R> field, float value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public double get(Field.DoubleField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.DoubleField<? super R> field, double value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public char get(Field.CharField<? super R> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.CharField<? super R> field, char value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <V> V get(Field.ObjectField<? super R, V> field) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public <V> void set(Field.ObjectField<? super R, V> field, V value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public boolean get(Field.BooleanArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, int index, boolean value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.BooleanArrayField<? super R> field, boolean[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.BooleanArrayField<? super R> field, boolean[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.BooleanArrayField<? super R> field, Record<S> source, Field.BooleanArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public byte get(Field.ByteArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, int index, byte value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.ByteArrayField<? super R> field, byte[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.ByteArrayField<? super R> field, byte[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.ByteArrayField<? super R> field, Record<S> source, Field.ByteArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public short get(Field.ShortArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, int index, short value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.ShortArrayField<? super R> field, short[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.ShortArrayField<? super R> field, short[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.ShortArrayField<? super R> field, Record<S> source, Field.ShortArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public int get(Field.IntArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int index, int value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.IntArrayField<? super R> field, int[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.IntArrayField<? super R> field, int[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.IntArrayField<? super R> field, Record<S> source, Field.IntArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public long get(Field.LongArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, int index, long value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.LongArrayField<? super R> field, long[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.LongArrayField<? super R> field, long[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.LongArrayField<? super R> field, Record<S> source, Field.LongArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public float get(Field.FloatArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, int index, float value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.FloatArrayField<? super R> field, float[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.FloatArrayField<? super R> field, float[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.FloatArrayField<? super R> field, Record<S> source, Field.FloatArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public double get(Field.DoubleArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, int index, double value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.DoubleArrayField<? super R> field, double[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.DoubleArrayField<? super R> field, double[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.DoubleArrayField<? super R> field, Record<S> source, Field.DoubleArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public char get(Field.CharArrayField<? super R> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, int index, char value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public void get(Field.CharArrayField<? super R> field, char[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public void set(Field.CharArrayField<? super R> field, char[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S> void set(Field.CharArrayField<? super R> field, Record<S> source, Field.CharArrayField<? super S> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <V> V get(Field.ObjectArrayField<? super R, V> field, int index) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, int index, V value) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <V> void get(Field.ObjectArrayField<? super R, V> field, V[] target, int offset) {
        throw new FieldNotFoundException(field, this);
    }

    @Override
    public <V> void set(Field.ObjectArrayField<? super R, V> field, V[] source, int offset) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }

    @Override
    public <S, V> void set(Field.ObjectArrayField<? super R, V> field, Record<S> source, Field.ObjectArrayField<? super S, V> sourceField) {
        throw this.fields().contains(field) ? new ReadOnlyFieldException(field, (Object)this) : new FieldNotFoundException(field, this);
    }
}

