/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.LifecycleListener;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.remote.RemoteChannelProxyFactoryService;
import co.paralleluniverse.strands.channels.SendPort;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Instrumented
public abstract class RemoteActor<Message>
extends ActorImpl<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteActor.class);
    private final transient ActorImpl<Message> actor;

    protected RemoteActor(ActorRef<Message> actor) {
        super(actor.getName(), (SendPort<Object>)RemoteChannelProxyFactoryService.create(actor.getImpl().mailbox(), (Object)((Actor)actor.getImpl()).getGlobalId()), actor);
        this.actor = actor.getImpl();
    }

    protected void handleAdminMessage(RemoteActorAdminMessage msg) {
        if (msg instanceof RemoteActorRegisterListenerAdminMessage) {
            this.actor.addLifecycleListener(((RemoteActorRegisterListenerAdminMessage)msg).getListener());
        } else if (msg instanceof RemoteActorUnregisterListenerAdminMessage) {
            RemoteActorUnregisterListenerAdminMessage unreg = (RemoteActorUnregisterListenerAdminMessage)msg;
            if (unreg.getObserver() != null) {
                this.actor.removeObserverListeners(unreg.getObserver());
            } else {
                this.actor.removeLifecycleListener(unreg.getListener());
            }
        } else if (msg instanceof RemoteActorInterruptAdminMessage) {
            this.actor.interrupt();
        } else if (msg instanceof RemoteActorThrowInAdminMessage) {
            this.actor.throwIn(((RemoteActorThrowInAdminMessage)msg).getException());
        }
    }

    public ActorImpl<Message> getActor() {
        return this.actor;
    }

    @Override
    protected void internalSendNonSuspendable(Object message) {
        this.actor.internalSendNonSuspendable(message);
    }

    @Override
    public boolean trySend(Message message) {
        this.internalSendNonSuspendable(message);
        return true;
    }

    @Override
    protected void addLifecycleListener(LifecycleListener listener) {
        this.internalSendNonSuspendable(new RemoteActorRegisterListenerAdminMessage(listener));
    }

    @Override
    protected void removeLifecycleListener(LifecycleListener listener) {
        this.internalSendNonSuspendable(new RemoteActorUnregisterListenerAdminMessage(listener));
    }

    @Override
    protected void removeObserverListeners(ActorRef observer) {
        this.internalSendNonSuspendable(new RemoteActorUnregisterListenerAdminMessage(observer));
    }

    @Override
    protected void throwIn(RuntimeException e) {
        this.internalSendNonSuspendable(new RemoteActorThrowInAdminMessage(e));
    }

    @Override
    public void interrupt() {
        this.internalSendNonSuspendable(new RemoteActorInterruptAdminMessage());
    }

    protected static ActorImpl getImpl(ActorRef<?> actor) {
        return actor.getImpl();
    }

    /*
     * Exception decompiling
     */
    @Override
    @Instrumented(suspendableCallSites={59}, suspendableCallSitesOffsetsAfterInstr={99}, methodStart=59, methodEnd=60, methodOptimized=false)
    protected void internalSend(Object var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class RemoteActorThrowInAdminMessage
    extends RemoteActorAdminMessage {
        private final RuntimeException e;

        public RemoteActorThrowInAdminMessage(RuntimeException e) {
            this.e = e;
        }

        public RuntimeException getException() {
            return this.e;
        }
    }

    private static class RemoteActorInterruptAdminMessage
    extends RemoteActorAdminMessage {
        private RemoteActorInterruptAdminMessage() {
        }
    }

    private static class RemoteActorUnregisterListenerAdminMessage
    extends RemoteActorAdminMessage {
        private final ActorRef observer;
        private final LifecycleListener listener;

        public RemoteActorUnregisterListenerAdminMessage(ActorRef observer) {
            this.observer = observer;
            this.listener = null;
        }

        public RemoteActorUnregisterListenerAdminMessage(LifecycleListener listener) {
            this.listener = listener;
            this.observer = null;
        }

        public ActorRef getObserver() {
            return this.observer;
        }

        public LifecycleListener getListener() {
            return this.listener;
        }
    }

    private static class RemoteActorRegisterListenerAdminMessage
    extends RemoteActorAdminMessage {
        private final LifecycleListener listener;

        public String toString() {
            return "RemoteActorListenerAdminMessage{listener=" + this.listener + '}';
        }

        public RemoteActorRegisterListenerAdminMessage(LifecycleListener listener) {
            this.listener = listener;
        }

        public LifecycleListener getListener() {
            return this.listener;
        }
    }

    protected static abstract class RemoteActorAdminMessage
    implements Serializable {
        protected RemoteActorAdminMessage() {
        }
    }
}

