/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.ActorMXBean;
import co.paralleluniverse.actors.ActorMonitor;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.common.monitoring.Counter;
import co.paralleluniverse.common.monitoring.MonitoringServices;
import co.paralleluniverse.common.util.Objects;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXActorMonitor
extends StandardEmitterMBean
implements ActorMonitor,
ActorMXBean,
NotificationListener,
NotificationEmitter {
    private static final Logger LOG = LoggerFactory.getLogger(JMXActorMonitor.class);
    private WeakReference<ActorRef> actor;
    private final String name;
    private boolean registered;
    private long lastCollectTime;
    private int notificationSequenceNumber;
    private int messageCounter;
    private int skippedMessageCounter;
    private final Counter restartCounter = new Counter();
    private final Queue<String> deathCauses = new ConcurrentLinkedQueue<String>();
    private volatile long messages;
    private volatile long skippedMessages;

    public JMXActorMonitor(String name) {
        super(ActorMXBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport());
        this.name = JMXActorMonitor.beanName(name);
        LOG.info("Starting monitor {}: {}", (Object)name, (Object)this.name);
        this.lastCollectTime = this.nanoTime();
        this.refresh();
        this.registerMBean();
    }

    private static String beanName(String name) {
        return "co.paralleluniverse:type=quasar,monitor=actor,name=" + name;
    }

    @Override
    public void setActor(ActorRef actor) {
        if (actor == null && this.actor == null) {
            return;
        }
        LOG.info("Setting actor {} for monitor {}", (Object)actor, (Object)this.name);
        this.reset();
        this.actor = actor != null ? new WeakReference<ActorRef>(actor) : null;
    }

    @Override
    public void shutdown() {
        LOG.info("Stopping monitor {}", (Object)this.name);
        this.unregisterMBean();
        this.actor = null;
    }

    private void registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.name);
            if (mbs.isRegistered(mxbeanName)) {
                try {
                    LOG.info("MBean named {} is already registered. Unregistering it.", (Object)this.name);
                    mbs.unregisterMBean(mxbeanName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    // empty catch block
                }
            }
            mbs.registerMBean(this, mxbeanName);
            MonitoringServices.getInstance().addPerfNotificationListener((NotificationListener)this, (Object)this.name);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (MalformedObjectNameException | NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void unregisterMBean() {
        try {
            if (this.registered) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.name));
                MonitoringServices.getInstance().removePerfNotificationListener((NotificationListener)this);
            }
            this.registered = false;
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String notifName = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, notifName, description);
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("perfTimer".equals(notification.getType())) {
            assert (Objects.equal((Object)handback, (Object)this.name));
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        if (this.registered) {
            WeakReference<ActorRef> a1 = this.actor;
            if (a1 != null && a1.get() == null) {
                this.unregisterMBean();
            } else {
                this.collect(this.nanoTime() - this.lastCollectTime);
            }
            this.reset();
        }
    }

    protected void collect(long intervalNanos) {
        this.messages += (long)this.messageCounter;
    }

    protected void reset() {
        this.messageCounter = 0;
        this.lastCollectTime = this.nanoTime();
    }

    private long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public void addDeath(Object cause) {
        if (cause == null) {
            cause = "normal";
        }
        while (this.deathCauses.size() > 20) {
            this.deathCauses.poll();
        }
        this.deathCauses.add(cause.toString());
    }

    @Override
    public void addRestart() {
        this.restartCounter.inc();
    }

    @Override
    public void addMessage() {
        ++this.messageCounter;
    }

    @Override
    public void skippedMessage() {
        ++this.skippedMessageCounter;
    }

    @Override
    public void resetSkippedMessages() {
        this.skippedMessageCounter = 0;
    }

    @Override
    public int getQueueLength() {
        if (this.actor == null) {
            return 0;
        }
        ActorRef a = (ActorRef)this.actor.get();
        if (a == null) {
            return 0;
        }
        return LocalActor.getQueueLength(a);
    }

    @Override
    public long getReceivedMessages() {
        return this.messages;
    }

    @Override
    public int getRestarts() {
        return (int)this.restartCounter.get();
    }

    @Override
    public String[] getLastDeathCauses() {
        return this.deathCauses.toArray(new String[0]);
    }

    @Override
    public String[] mailbox() {
        ActorRef a;
        WeakReference<ActorRef> a1 = this.actor;
        ActorRef actorRef = a = a1 != null ? (ActorRef)a1.get() : null;
        if (a == null) {
            this.unregisterMBean();
            return null;
        }
        List<Object> list = LocalActor.getMailboxSnapshot(a);
        String[] ms = new String[list.size()];
        int i = 0;
        for (Object m : list) {
            ms[i++] = m.toString();
        }
        return ms;
    }

    @Override
    public String stackTrace() {
        ActorRef a;
        WeakReference<ActorRef> a1 = this.actor;
        ActorRef actorRef = a = a1 != null ? (ActorRef)a1.get() : null;
        if (a == null) {
            this.unregisterMBean();
            return null;
        }
        StackTraceElement[] stackTrace = LocalActor.getStackTrace(a);
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement ste : stackTrace) {
            sb.append(ste).append('\n');
        }
        return sb.toString();
    }
}

