/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorModule;
import co.paralleluniverse.actors.OnUpgrade;
import co.paralleluniverse.common.util.Exceptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.ReflectionFactory;

class InstanceUpgrader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceUpgrader.class);
    private static final Object reflFactory;
    static final ClassValue<InstanceUpgrader<?>> instanceUpgrader;
    private final Class<T> toClass;
    private final Map<FieldDesc, FieldInfo> fields;
    private final Map<FieldDesc, Field> staticFields;
    private final ConcurrentMap<Class, Copier> copiers;
    private final Constructor<T> ctor;
    private final List<Method> onUpgradeInstance;
    private final List<Method> onUpgradeStatic;

    public static <T> InstanceUpgrader<T> get(Class<T> clazz) {
        return instanceUpgrader.get(clazz);
    }

    public InstanceUpgrader(Class<T> toClass) {
        this.toClass = toClass;
        this.copiers = new MapMaker().weakKeys().makeMap();
        Map<FieldDesc, Field> fs = InstanceUpgrader.getInstanceFields(toClass, new HashMap<FieldDesc, Field>());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<FieldDesc, Field> entry : fs.entrySet()) {
            Field f = entry.getValue();
            f.setAccessible(true);
            Constructor<?> innerClassCtor = null;
            if (Objects.equals(f.getType().getEnclosingClass(), toClass)) {
                try {
                    innerClassCtor = f.getType().getDeclaredConstructor(toClass);
                    innerClassCtor.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            builder.put((Object)entry.getKey(), (Object)new FieldInfo(f, innerClassCtor));
        }
        this.fields = builder.build();
        this.staticFields = ImmutableMap.copyOf(InstanceUpgrader.getStaticFields(toClass, new HashMap<FieldDesc, Field>()));
        for (Field sf : this.staticFields.values()) {
            sf.setAccessible(true);
        }
        this.ctor = InstanceUpgrader.getNoArgConstructor(toClass);
        List upgradeMethods = InstanceUpgrader.getAnnotatedMethods(toClass, OnUpgrade.class, new ArrayList());
        ImmutableList.Builder ouib = ImmutableList.builder();
        ImmutableList.Builder ousb = ImmutableList.builder();
        for (Method m : upgradeMethods) {
            if (m.getParameterTypes().length > 0) {
                LOG.warn("@OnUpgrade method {} takes arguments and will therefore not be invoked.", (Object)m);
                continue;
            }
            m.setAccessible(true);
            if (Modifier.isStatic(m.getModifiers())) {
                ousb.add((Object)m);
                continue;
            }
            ouib.add((Object)m);
        }
        this.onUpgradeInstance = ouib.build();
        this.onUpgradeStatic = ousb.build();
    }

    private static <T> Constructor<T> getNoArgConstructor(Class<T> clazz) {
        if (reflFactory == null) {
            return InstanceUpgrader.getNoArgConstructor1(clazz);
        }
        return InstanceUpgrader.getNoArgConstructor2(clazz);
    }

    private static <T> Constructor<T> getNoArgConstructor1(Class<T> clazz) {
        try {
            Constructor<T> cons = clazz.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static <T> Constructor<T> getNoArgConstructor2(Class<T> clazz) {
        Class initCl = Actor.class.isAssignableFrom(clazz) ? Actor.class : Object.class;
        try {
            Constructor<Object> cons = initCl.getDeclaredConstructor(new Class[0]);
            cons = ((ReflectionFactory)reflFactory).newConstructorForSerialization(clazz, cons);
            cons.setAccessible(true);
            return cons;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public T copy(T from, T to) {
        assert (this.toClass.isInstance(to));
        return this.getCopier(from.getClass()).copy(from, to);
    }

    public T copy(T from) {
        return this.getCopier(from.getClass()).copy(from);
    }

    private Copier<T> getCopier(Class<?> fromClass) {
        Copier<?> temp;
        Copier copier = (Copier)this.copiers.get(fromClass);
        if (copier == null && (temp = this.copiers.putIfAbsent(fromClass, copier = new Copier(fromClass))) != null) {
            copier = temp;
        }
        return copier;
    }

    private static Map<FieldDesc, Field> getInstanceFields(Class<?> clazz, Map<FieldDesc, Field> fields) {
        if (clazz == null) {
            return fields;
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            fields.put(new FieldDesc(f), f);
        }
        return InstanceUpgrader.getInstanceFields(clazz.getSuperclass(), fields);
    }

    private static Map<FieldDesc, Field> getStaticFields(Class<?> clazz, Map<FieldDesc, Field> fields) {
        if (clazz == null) {
            return fields;
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers())) continue;
            fields.put(new FieldDesc(f), f);
        }
        return InstanceUpgrader.getStaticFields(clazz.getSuperclass(), fields);
    }

    private static <T extends Collection<Method>> T getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> ann, T methods) {
        if (clazz == null) {
            return methods;
        }
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getAnnotation(ann) == null) continue;
            methods.add((Method)m);
        }
        return methods;
    }

    private static boolean isInnerClassOf(Class<?> maybeInner, Class<?> maybeOuter) {
        return Objects.equals(maybeInner.getEnclosingClass(), maybeOuter) && InstanceUpgrader.hasField(maybeInner, "this$0");
    }

    private static boolean hasField(Class<?> clazz, String field) {
        try {
            clazz.getDeclaredField(field);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    static void setFinalStatic(Field field, Object newValue) throws IllegalAccessException {
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, newValue);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        instanceUpgrader = new ClassValue<InstanceUpgrader<?>>(){

            @Override
            protected InstanceUpgrader<?> computeValue(Class<?> type) {
                return new InstanceUpgrader(type);
            }
        };
        ReflectionFactory rf = null;
        try {
            rf = ReflectionFactory.getReflectionFactory();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        reflFactory = rf;
    }

    private static class FieldInfo {
        final Field field;
        final Constructor innerClassCtor;

        public FieldInfo(Field field, Constructor innerClassCtor) {
            this.field = field;
            this.innerClassCtor = innerClassCtor;
        }
    }

    private static class FieldDesc {
        final String declaringClass;
        final String name;

        FieldDesc(Field field) {
            this(field.getDeclaringClass().getName(), field.getName());
        }

        FieldDesc(String declaringClass, String name) {
            this.declaringClass = declaringClass;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FieldDesc)) {
                return false;
            }
            FieldDesc other = (FieldDesc)obj;
            return this.declaringClass.equals(other.declaringClass) && this.name.equals(other.name);
        }

        public int hashCode() {
            return this.declaringClass.hashCode() ^ this.name.hashCode();
        }
    }

    private class Copier<T> {
        private final Class<T> fromClass;
        private final Field[] fromFields;
        private final Field[] toFields;
        private final Constructor[] innerClassConstructor;
        private final Copier[] fieldCopier;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Copier(Class<T> fromClass) {
            if (!fromClass.getName().equals(InstanceUpgrader.this.toClass.getName())) {
                throw new IllegalArgumentException("'fromClass' " + fromClass.getName() + " is not a version of 'toClass' " + InstanceUpgrader.this.toClass.getName());
            }
            this.fromClass = fromClass;
            InstanceUpgrader instanceUpgrader2 = InstanceUpgrader.this;
            synchronized (instanceUpgrader2) {
                try {
                    Map sfs = InstanceUpgrader.getStaticFields(fromClass, new HashMap());
                    for (Map.Entry e : sfs.entrySet()) {
                        Object toFieldValue;
                        Field tf = (Field)InstanceUpgrader.this.staticFields.get(e.getKey());
                        Field ff = (Field)e.getValue();
                        ff.setAccessible(true);
                        if (tf == null || Modifier.isFinal(tf.getModifiers())) continue;
                        Object fromFieldValue = ff.get(null);
                        if (tf.getType().isAssignableFrom(ff.getType())) {
                            toFieldValue = fromFieldValue;
                        } else {
                            if (!tf.getType().getName().equals(ff.getType().getName())) continue;
                            toFieldValue = ((InstanceUpgrader)InstanceUpgrader.instanceUpgrader.get(tf.getType())).getCopier(ff.getType()).copy(fromFieldValue);
                        }
                        LOG.debug("== static: {} <- {}: {} ({})", new Object[]{tf, ff, toFieldValue, fromFieldValue});
                        tf.set(null, toFieldValue);
                    }
                    try {
                        for (Method m : InstanceUpgrader.this.onUpgradeStatic) {
                            m.invoke(null, new Object[0]);
                        }
                    }
                    catch (InvocationTargetException e) {
                        throw Exceptions.rethrow((Throwable)e.getCause());
                    }
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            Map fs = InstanceUpgrader.getInstanceFields(fromClass, new HashMap());
            ArrayList<Field> ffs = new ArrayList<Field>();
            ArrayList<Field> tfs = new ArrayList<Field>();
            ArrayList<Constructor> ics = new ArrayList<Constructor>();
            ArrayList<Copier> fcs = new ArrayList<Copier>();
            for (Map.Entry e : fs.entrySet()) {
                Field ff = (Field)e.getValue();
                FieldInfo tfi = (FieldInfo)InstanceUpgrader.this.fields.get(e.getKey());
                Field tf = tfi != null ? tfi.field : null;
                if (tf == null) continue;
                boolean assignable = false;
                Constructor innerClassCtor = null;
                Copier fc = null;
                if ("this$0".equals(tf.getName())) continue;
                if (Objects.equals(ff.getType().getEnclosingClass(), fromClass) && Objects.equals(tf.getType().getEnclosingClass(), InstanceUpgrader.this.toClass)) {
                    innerClassCtor = tfi.innerClassCtor;
                    fc = ((InstanceUpgrader)InstanceUpgrader.instanceUpgrader.get(tf.getType())).getCopier(ff.getType());
                } else if (tf.getType().isAssignableFrom(ff.getType())) {
                    assignable = true;
                } else if (tf.getType().getName().equals(ff.getType().getName())) {
                    fc = ((InstanceUpgrader)InstanceUpgrader.instanceUpgrader.get(tf.getType())).getCopier(ff.getType());
                }
                if (!assignable && innerClassCtor == null && fc == null) continue;
                ffs.add(ff);
                tfs.add(tf);
                fcs.add(fc);
                ics.add(innerClassCtor);
            }
            this.fromFields = ffs.toArray(new Field[ffs.size()]);
            this.toFields = tfs.toArray(new Field[tfs.size()]);
            this.fieldCopier = fcs.toArray(new Copier[fcs.size()]);
            this.innerClassConstructor = ics.toArray(new Constructor[ics.size()]);
            for (Field f : this.fromFields) {
                f.setAccessible(true);
            }
        }

        T copy(T from, T to) {
            try {
                for (int i = 0; i < this.fromFields.length; ++i) {
                    Object toFieldValue;
                    Object fromFieldValue = this.fromFields[i].get(from);
                    if (this.innerClassConstructor[i] != null) {
                        toFieldValue = this.fieldCopier[i].copy(fromFieldValue, this.innerClassConstructor[i].newInstance(to));
                    } else if (this.fieldCopier[i] != null) {
                        toFieldValue = this.fieldCopier[i].copy(fromFieldValue);
                    } else if (fromFieldValue != null && InstanceUpgrader.isInnerClassOf(fromFieldValue.getClass(), this.fromClass)) {
                        Class<?> fromFieldValueClass = fromFieldValue.getClass();
                        if (fromFieldValueClass.isAnonymousClass()) {
                            toFieldValue = null;
                        } else {
                            Object tfv = null;
                            try {
                                Class<?> toFieldValueClass = InstanceUpgrader.this.toClass.getClassLoader().loadClass(fromFieldValueClass.getName());
                                Copier c = ((InstanceUpgrader)instanceUpgrader.get(toFieldValueClass)).getCopier(fromFieldValueClass);
                                Constructor<?> cstr = toFieldValueClass.getDeclaredConstructor(InstanceUpgrader.this.toClass);
                                cstr.setAccessible(true);
                                tfv = c.copy(fromFieldValue, cstr.newInstance(to));
                            }
                            catch (ClassNotFoundException | NoSuchMethodException e) {
                                LOG.debug("Exception while copying " + this.fromFields[i] + " to " + this.toFields[i] + "(" + fromFieldValue + ")", (Throwable)e);
                            }
                            toFieldValue = tfv;
                        }
                    } else {
                        toFieldValue = fromFieldValue;
                    }
                    this.toFields[i].set(to, toFieldValue);
                }
                try {
                    for (Method m : InstanceUpgrader.this.onUpgradeInstance) {
                        m.invoke(to, new Object[0]);
                    }
                }
                catch (InvocationTargetException e) {
                    throw Exceptions.rethrow((Throwable)e.getCause());
                }
                return to;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }

        T copy(T from) {
            if (from == null) {
                return null;
            }
            if (InstanceUpgrader.this.ctor == null) {
                throw new RuntimeException("Class " + InstanceUpgrader.this.toClass.getName() + " in module " + (InstanceUpgrader.this.toClass.getClassLoader() instanceof ActorModule ? InstanceUpgrader.this.toClass.getClassLoader() : null) + " does not have a no-arg constructor.");
            }
            try {
                Object to = InstanceUpgrader.this.ctor.newInstance(new Object[0]);
                return this.copy(from, to);
            }
            catch (InstantiationException | InvocationTargetException ex) {
                throw Exceptions.rethrow((Throwable)ex.getCause());
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }
}

