/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorLoader;
import co.paralleluniverse.actors.Upgrade;
import co.paralleluniverse.actors.behaviors.EventHandler;
import co.paralleluniverse.actors.behaviors.Initializer;
import co.paralleluniverse.actors.behaviors.ServerHandler;
import co.paralleluniverse.common.reflection.ASMUtil;
import co.paralleluniverse.common.reflection.AnnotationUtil;
import co.paralleluniverse.common.reflection.ClassLoaderUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActorModule
extends URLClassLoader {
    private static final Class<?>[] AUTOMATIC_UPGRADE_CLASSES = new Class[]{Actor.class, Initializer.class, ServerHandler.class, EventHandler.class};
    private static final Logger LOG;
    private static final String UPGRADE_CLASSES_ATTR = "Upgrade-Classes";
    private final URL url;
    private final ClassLoader parent;
    private final Set<String> upgradeClasses;

    public ActorModule(URL jarUrl, ActorLoader parent) {
        super(new URL[]{jarUrl}, (ClassLoader)null);
        this.url = jarUrl;
        this.parent = parent;
        try {
            JarFile jar = new JarFile(new File(jarUrl.toURI()));
            final ImmutableSet.Builder builder = ImmutableSet.builder();
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String ucstr = attributes.getValue(UPGRADE_CLASSES_ATTR);
            if (ucstr != null && !ucstr.trim().isEmpty()) {
                if (ucstr.trim().equals("*")) {
                    ClassLoaderUtil.accept((URLClassLoader)this, (ClassLoaderUtil.Visitor)new ClassLoaderUtil.Visitor(){

                        public void visit(String resource, URL url, ClassLoader cl) {
                            if (!ClassLoaderUtil.isClassFile((String)resource)) {
                                return;
                            }
                            String className = ClassLoaderUtil.resourceToClass((String)resource);
                            if (ActorModule.this.isAutomaticUpgrade(className) && !ActorModule.equalContent(ActorModule.this.parent.getResource(resource), url)) {
                                builder.add((Object)className);
                            }
                        }
                    });
                } else {
                    for (String className : ucstr.split("\\s")) {
                        LOG.debug("Upgrade of class {} (JAR manifest)", (Object)className);
                        builder.add((Object)className);
                    }
                }
            }
            ClassLoaderUtil.accept((URLClassLoader)this, (ClassLoaderUtil.Visitor)new ClassLoaderUtil.Visitor(){

                public void visit(String resource, URL url, ClassLoader cl) {
                    if (!ClassLoaderUtil.isClassFile((String)resource)) {
                        return;
                    }
                    String className = ClassLoaderUtil.resourceToClass((String)resource);
                    try (InputStream is = cl.getResourceAsStream(resource);){
                        if (AnnotationUtil.hasClassAnnotation(Upgrade.class, (InputStream)is)) {
                            LOG.debug("Upgrade of class {} (annotated)", (Object)className);
                            builder.add((Object)className);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Exception while scanning class " + className + " for Upgrade annotation", e);
                    }
                }
            });
            this.upgradeClasses = builder.build();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAutomaticUpgrade(String className) {
        for (Class<?> c : AUTOMATIC_UPGRADE_CLASSES) {
            if (!ASMUtil.isAssignableFrom(c, (String)className, (ClassLoader)this)) continue;
            LOG.debug("Automatic upgrade of class {} (implements/extends {})", (Object)className, c);
            return true;
        }
        return false;
    }

    public URL getURL() {
        return this.url;
    }

    public Set<String> getUpgradeClasses() {
        return this.upgradeClasses;
    }

    public Class<?> loadClassInModule(String name) throws ClassNotFoundException {
        Class<?> loaded = super.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        return super.loadClass(name);
    }

    public Class<?> findLoadedClassInModule(String name) {
        return super.findLoadedClass(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> loaded = super.findLoadedClass(name);
        if (loaded != null) {
            return loaded;
        }
        LOG.debug("findClass {} in module {}", (Object)name, (Object)this);
        boolean isUpgraded = this.upgradeClasses.contains(name);
        if (!isUpgraded && this.parent != null && !name.contains("$")) {
            try {
                URL myUrl;
                String resourceName = ClassLoaderUtil.classToResource((String)name);
                URL parentUrl = this.parent.getResource(resourceName);
                LOG.debug("findClass {} in module {} - parent URL: {}", new Object[]{name, this, parentUrl});
                if (parentUrl != null && ((myUrl = super.getResource(resourceName)) == null || ActorModule.equalContent(parentUrl, myUrl))) {
                    if (myUrl != null) {
                        LOG.debug("Class {} in module {} is identical to that in main module", (Object)name, (Object)this);
                    } else {
                        LOG.debug("findClass {} in module {} - not found in module", (Object)name, (Object)this);
                    }
                    return this.parent.loadClass(name);
                }
            }
            catch (ClassNotFoundException resourceName) {
                // empty catch block
            }
        }
        try {
            Class<?> clazz = super.findClass(name);
            LOG.info("{} loaded {} class {}", new Object[]{this, isUpgraded ? "upgraded" : "internal", name});
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
            throw e;
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url != null) {
            LOG.debug("{} - getResource {}: {}", new Object[]{this, name, url});
        }
        if (url == null && this.parent != null) {
            url = this.parent.getResource(name);
        }
        return url;
    }

    public String toString() {
        return "ActorModule{url=" + this.url + '}';
    }

    private static boolean equalContent(URL url1, URL url2) {
        try {
            return Resources.asByteSource((URL)url1).contentEquals(Resources.asByteSource((URL)url2));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
        LOG = LoggerFactory.getLogger(ActorModule.class);
    }
}

