/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.actors;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorRefDelegate;
import co.paralleluniverse.actors.ExitMessage;
import co.paralleluniverse.actors.LifecycleListener;
import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.channels.SendPort;
import co.paralleluniverse.strands.queues.QueueCapacityExceededException;
import java.io.Serializable;
import java.util.Objects;

@Instrumented
public abstract class ActorImpl<Message>
implements Serializable {
    static final long serialVersionUID = 894359345L;
    private static final int MAX_SEND_RETRIES = 10;
    protected transient ActorRef<Message> ref;
    private volatile String name;
    private final SendPort<Object> mailbox;
    private LifecycleListener lifecycleListener;
    protected final transient FlightRecorder flightRecorder;

    public String toString() {
        return "Actor@" + (this.name != null ? this.name : Integer.toHexString(System.identityHashCode(this)));
    }

    protected ActorImpl(String name, SendPort<Object> mailbox, ActorRef<Message> ref) {
        this.name = name;
        this.mailbox = mailbox;
        this.flightRecorder = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;
        this.ref = ref != null ? ref : new ActorRef(this);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("Actor " + this + " already has a name: " + this.name);
        }
        this.name = name;
    }

    public ActorRef<Message> ref() {
        return this.ref;
    }

    void setRef(ActorRef<Message> ref) {
        this.ref = ref;
    }

    protected SendPort<Object> mailbox() {
        return this.mailbox;
    }

    public SendPort<Object> getMailbox() {
        return this.mailbox;
    }

    public void sendOrInterrupt(Object message) {
        try {
            this.internalSendNonSuspendable(message);
        }
        catch (QueueCapacityExceededException e) {
            this.interrupt();
        }
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    public void close(Throwable t) {
        throw new UnsupportedOperationException();
    }

    protected abstract void interrupt();

    protected abstract boolean trySend(Message var1);

    protected abstract void internalSend(Object var1) throws SuspendExecution;

    protected abstract void internalSendNonSuspendable(Object var1);

    protected abstract void throwIn(RuntimeException var1);

    protected abstract void addLifecycleListener(LifecycleListener var1);

    protected abstract void removeLifecycleListener(LifecycleListener var1);

    protected abstract void removeObserverListeners(ActorRef var1);

    protected LifecycleListener getLifecycleListener() {
        if (this.lifecycleListener == null) {
            this.lifecycleListener = new ActorLifecycleListener(this.ref(), null);
        }
        return this.lifecycleListener;
    }

    static ActorImpl getActorRefImpl(ActorRef actor) {
        while (actor instanceof ActorRefDelegate) {
            actor = ((ActorRefDelegate)actor).getRef();
        }
        return actor.getImpl();
    }

    protected final boolean isRecordingLevel(int level) {
        if (this.flightRecorder == null) {
            return false;
        }
        FlightRecorder.ThreadRecorder recorder = this.flightRecorder.get();
        if (recorder == null) {
            return false;
        }
        return recorder.recordsLevel(level);
    }

    protected final void record(int level, String clazz, String method, String format) {
        if (this.flightRecorder != null) {
            ActorImpl.record(this.flightRecorder.get(), level, clazz, method, format);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1) {
        if (this.flightRecorder != null) {
            ActorImpl.record(this.flightRecorder.get(), level, clazz, method, format, arg1);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2) {
        if (this.flightRecorder != null) {
            ActorImpl.record(this.flightRecorder.get(), level, clazz, method, format, arg1, arg2);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3) {
        if (this.flightRecorder != null) {
            ActorImpl.record(this.flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.flightRecorder != null) {
            ActorImpl.record(this.flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3, arg4);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (this.flightRecorder != null) {
            ActorImpl.record(this.flightRecorder.get(), level, clazz, method, format, arg1, arg2, arg3, arg4, arg5);
        }
    }

    protected final void record(int level, String clazz, String method, String format, Object ... args) {
        if (this.flightRecorder != null) {
            ActorImpl.record(this.flightRecorder.get(), level, clazz, method, format, args);
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format) {
        if (recorder != null) {
            recorder.record(level, (Object)ActorImpl.makeFlightRecorderMessage(recorder, clazz, method, format, null));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1) {
        if (recorder != null) {
            recorder.record(level, (Object)ActorImpl.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2) {
        if (recorder != null) {
            recorder.record(level, (Object)ActorImpl.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3) {
        if (recorder != null) {
            recorder.record(level, (Object)ActorImpl.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (recorder != null) {
            recorder.record(level, (Object)ActorImpl.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (recorder != null) {
            recorder.record(level, (Object)ActorImpl.makeFlightRecorderMessage(recorder, clazz, method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    private static void record(FlightRecorder.ThreadRecorder recorder, int level, String clazz, String method, String format, Object ... args) {
        if (recorder != null) {
            recorder.record(level, (Object)ActorImpl.makeFlightRecorderMessage(recorder, clazz, method, format, args));
        }
    }

    private static FlightRecorderMessage makeFlightRecorderMessage(FlightRecorder.ThreadRecorder recorder, String clazz, String method, String format, Object[] args) {
        return new FlightRecorderMessage(clazz, method, format, args);
    }

    /*
     * Exception decompiling
     */
    @Instrumented(suspendableCallSites={86}, suspendableCallSitesOffsetsAfterInstr={102}, methodStart=84, methodEnd=90, methodOptimized=false)
    protected void sendSync(Message var1_1) throws SuspendExecution {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static class ActorLifecycleListener
    implements LifecycleListener,
    Serializable {
        private final ActorRef observer;
        private final Object id;

        public ActorLifecycleListener(ActorRef observer, Object id) {
            this.observer = observer;
            this.id = id;
        }

        @Override
        public void dead(ActorRef actor, Throwable cause) {
            this.observer.getImpl().internalSendNonSuspendable(new ExitMessage(actor, cause, this.id));
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ActorLifecycleListener)) {
                return false;
            }
            return Objects.equals(this.observer, ((ActorLifecycleListener)obj).observer) && Objects.equals(this.id, ((ActorLifecycleListener)obj).id);
        }

        public String toString() {
            return "ActorLifecycleListener{observer: " + this.observer + ", id: " + this.id + '}';
        }

        @Override
        public Object getId() {
            return this.id;
        }

        public ActorRef getObserver() {
            return this.observer;
        }
    }
}

