/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.NotSerializableException;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

class ReferenceSerializer
extends Serializer<Reference<?>> {
    public ReferenceSerializer() {
        this.setImmutable(true);
    }

    @Override
    public void write(Kryo kryo, Output output, Reference<?> r) {
        if (r instanceof PhantomReference) {
            throw new RuntimeException(new NotSerializableException(r.getClass().getName()));
        }
        boolean strong = !(r instanceof WeakReference) && !(r instanceof SoftReference);
        kryo.writeClassAndObject(output, strong ? r.get() : null);
    }

    @Override
    public Reference<?> read(Kryo kryo, Input input, Class<Reference<?>> type) {
        assert (!PhantomReference.class.isAssignableFrom(type));
        boolean strong = !WeakReference.class.isAssignableFrom(type) && !SoftReference.class.isAssignableFrom(type);
        Object val = kryo.readClassAndObject(input);
        assert (val == null || !strong);
        try {
            return type.getConstructor(Object.class).newInstance(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

