/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import co.paralleluniverse.io.serialization.ByteArraySerializer;
import co.paralleluniverse.io.serialization.IOStreamSerializer;
import co.paralleluniverse.io.serialization.kryo.KryoUtil;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class KryoSerializer
implements ByteArraySerializer,
IOStreamSerializer {
    private static Queue<Registration> registrations = new ConcurrentLinkedQueue<Registration>();
    public final Kryo kryo = KryoUtil.newKryo();
    private Input input;
    private Output output;
    private static Serializer NULL_SERIALIZER = new Serializer<Object>(){

        @Override
        public void write(Kryo kryo, Output output, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object read(Kryo kryo, Input input, Class<Object> type) {
            throw new UnsupportedOperationException();
        }
    };

    public KryoSerializer() {
        KryoUtil.registerCommonClasses(this.kryo);
        for (Registration r : registrations) {
            this.register(r);
        }
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public static void register(Class type) {
        KryoSerializer.register(type, NULL_SERIALIZER, -1);
    }

    public static void register(Class type, int id) {
        KryoSerializer.register(type, NULL_SERIALIZER, id);
    }

    public static void register(Class type, Serializer ser) {
        KryoSerializer.register(type, ser, -1);
    }

    public static void register(Class type, Serializer ser, int id) {
        registrations.add(new Registration(type, ser, id));
    }

    private Input getInput() {
        if (this.input == null) {
            this.input = new Input(4096);
        }
        return this.input;
    }

    private Output getOutput() {
        if (this.output == null) {
            this.output = new Output(4096, -1);
        }
        return this.output;
    }

    private void register(Registration r) {
        if (r.getId() < 0 && r.getSerializer() == NULL_SERIALIZER) {
            this.kryo.register(r.getType());
        } else if (r.getId() < 0) {
            this.kryo.register(r.getType(), r.getSerializer());
        } else if (r.getSerializer() == NULL_SERIALIZER) {
            this.kryo.register(r.getType(), r.getId());
        } else {
            this.kryo.register(r.getType(), r.getSerializer(), r.getId());
        }
    }

    @Override
    public byte[] write(Object object) {
        Output out = this.getOutput();
        out.clear();
        this.kryo.writeClassAndObject(out, object);
        out.flush();
        return out.toBytes();
    }

    @Override
    public Object read(byte[] buf) {
        return this.read(buf, 0);
    }

    @Override
    public Object read(byte[] buf, int offset) {
        Input in = new Input(buf, offset, buf.length - offset);
        return this.kryo.readClassAndObject(in);
    }

    public <T> T read(byte[] buf, Class<T> type) {
        return this.read(buf, 0, type);
    }

    public <T> T read(byte[] buf, int offset, Class<T> type) {
        Input in = new Input(buf, offset, buf.length - offset);
        return this.kryo.readObjectOrNull(in, type);
    }

    @Override
    public void write(OutputStream os, Object object) {
        Output out = this.getOutput();
        out.clear();
        out.setOutputStream(os);
        this.kryo.writeClassAndObject(out, object);
        out.flush();
        out.setOutputStream(null);
    }

    @Override
    public Object read(InputStream is) throws IOException {
        Input in = this.getInput();
        in.setInputStream(is);
        return this.kryo.readClassAndObject(in);
    }

    public <T> T read(InputStream is, Class<T> type) {
        Input in = this.getInput();
        in.setInputStream(is);
        return this.kryo.readObjectOrNull(this.input, type);
    }
}

