/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.io.serialization.Serialization;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;

public class ThreadLocalSerializer
extends Serializer<ThreadLocal<?>> {
    public static boolean PRINT_WARNINGS_ON_UNSERIALIZABLE_THREAD_LOCAL = false;

    public ThreadLocalSerializer() {
        this.setImmutable(true);
    }

    @Override
    public void write(Kryo kryo, Output output, ThreadLocal<?> tl) {
        output.writeBoolean(tl instanceof InheritableThreadLocal);
        Object val = tl.get();
        boolean serializable = ThreadLocalSerializer.canSerialize(kryo, tl, val);
        output.writeBoolean(serializable);
        if (serializable) {
            kryo.writeClassAndObject(output, val);
        }
    }

    @Override
    public ThreadLocal<?> read(Kryo kryo, Input input, Class<ThreadLocal<?>> type) {
        boolean inheritable = input.readBoolean();
        ThreadLocal tl = inheritable ? new InheritableThreadLocal() : new ThreadLocal();
        boolean serializable = input.readBoolean();
        if (serializable) {
            tl.set(kryo.readClassAndObject(input));
        }
        return tl;
    }

    private static boolean canSerialize(Kryo kryo, ThreadLocal<?> tl, Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof Serializable || kryo.getClassResolver().getRegistration(val.getClass()) != null) {
            return true;
        }
        if (val instanceof Serialization) {
            return false;
        }
        if (!kryo.getDefaultSerializer(val.getClass()).getClass().isAssignableFrom(FieldSerializer.class)) {
            return true;
        }
        if (PRINT_WARNINGS_ON_UNSERIALIZABLE_THREAD_LOCAL) {
            System.err.println("WARNING: Cannot serialize ThreadLocal (" + tl + " = " + val + "), it will be restored as null.");
        }
        return false;
    }
}

