/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.concurrent.atomic.AtomicLong;

public class EnhancedAtomicLong
extends AtomicLong {
    public static final Function<Long, Long> DEC = new Function<Long, Long>(){

        @Override
        public Long apply(Long l) {
            return l - 1L;
        }
    };

    public static Predicate<Long> gt(final long n) {
        return new Predicate<Long>(){

            @Override
            public boolean apply(Long l) {
                return l > n;
            }
        };
    }

    public boolean evalAndUpdate(Predicate<Long> predicate, Function<Long, Long> update) {
        long val;
        boolean satisfied;
        while ((satisfied = predicate.apply(val = this.get())) && !this.compareAndSet(val, update.apply(val))) {
        }
        return satisfied;
    }
}

