/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import jsr166e.LongAdder;
import jsr166e.LongMaxUpdater;

public class SimpleReservoir
implements Reservoir {
    private final LongAdder num = new LongAdder();
    private final LongAdder sum = new LongAdder();
    private final LongMaxUpdater max = new LongMaxUpdater();
    private final LongMaxUpdater min = new LongMaxUpdater();

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void update(long value) {
        this.num.increment();
        this.sum.add(value);
        this.max.update(value);
        this.min.update(-value);
    }

    @Override
    public Snapshot getSnapshot() {
        return new Snapshot(){
            private final long num;
            private final long sum;
            private final long max;
            private final long min;
            {
                this.num = SimpleReservoir.this.num.sumThenReset();
                this.sum = SimpleReservoir.this.sum.sumThenReset();
                this.max = SimpleReservoir.this.max.maxThenReset();
                this.min = SimpleReservoir.this.min.maxThenReset();
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public long getMax() {
                return this.max;
            }

            @Override
            public long getMin() {
                return -this.min;
            }

            @Override
            public double getMean() {
                return (double)this.sum / (double)this.num;
            }

            @Override
            public double getValue(double quantile) {
                if (quantile >= 1.0) {
                    return this.max;
                }
                if (quantile == 0.0) {
                    return this.min;
                }
                return -1.0;
            }

            @Override
            public long[] getValues() {
                return new long[]{this.min, this.max};
            }

            @Override
            public double getStdDev() {
                return 0.0;
            }

            @Override
            public void dump(OutputStream out) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

