/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import co.paralleluniverse.common.monitoring.MonitoringServicesMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.timer.Timer;

public final class MonitoringServices
implements MonitoringServicesMXBean {
    public static final MonitoringServices instance = new MonitoringServices();
    private final Timer timer = new Timer();
    private int perfTimerPeriod = 5000;
    private int structuralTimerPeriod = 30000;
    private boolean perfTimerStarted;
    private boolean structuralTimerStarted;
    private int perfTimerListeners;
    private int structuralTimerListeners;

    public static MonitoringServices getInstance() {
        return instance;
    }

    private MonitoringServices() {
        this.registerMBean();
        this.perfTimerListeners = 0;
        this.structuralTimerListeners = 0;
        this.killTimerOnExit();
        this.startPerformanceUpdates();
    }

    private synchronized void manageTimer() {
        if (!this.timer.isActive()) {
            if (this.perfTimerStarted && this.perfTimerListeners > 0 || this.structuralTimerStarted && this.structuralTimerListeners > 0) {
                this.timer.start();
            }
        } else if (!(this.perfTimerStarted && this.perfTimerListeners != 0 || this.structuralTimerStarted && this.structuralTimerListeners != 0)) {
            this.timer.stop();
        }
    }

    private void registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("co.paralleluniverse:name=MonitoringServices");
            mbs.registerMBean(this, mxbeanName);
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public synchronized int getPerformanceTimerPeriod() {
        return this.perfTimerPeriod;
    }

    @Override
    public synchronized void setPerformanceTimerPeriod(int perfTimerPeriod) {
        if (perfTimerPeriod != this.perfTimerPeriod) {
            this.perfTimerPeriod = perfTimerPeriod;
            if (this.perfTimerStarted) {
                this.stopPerformanceUpdates();
                this.startPerformanceUpdates();
            }
        }
    }

    @Override
    public synchronized boolean isPerformanceUpdates() {
        return this.perfTimerStarted;
    }

    @Override
    public synchronized void setPerformanceUpdates(boolean value) {
        if (value == this.perfTimerStarted) {
            return;
        }
        if (!this.perfTimerStarted) {
            this.startPerformanceUpdates();
        } else {
            this.stopPerformanceUpdates();
        }
    }

    @Override
    public synchronized void startPerformanceUpdates() {
        if (!this.perfTimerStarted) {
            this.timer.addNotification("perfTimer", null, null, new Date(System.currentTimeMillis()), this.perfTimerPeriod);
            this.perfTimerStarted = true;
        }
        this.manageTimer();
    }

    @Override
    public synchronized void stopPerformanceUpdates() {
        if (this.perfTimerStarted) {
            try {
                this.timer.removeNotifications("perfTimer");
                this.perfTimerStarted = false;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
        }
        this.manageTimer();
    }

    public synchronized void addPerfNotificationListener(NotificationListener listener, Object handback) {
        this.timer.addNotificationListener(listener, new NotificationFilter(){

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                return "perfTimer".equals(notification.getType());
            }
        }, handback);
        ++this.perfTimerListeners;
        this.manageTimer();
    }

    public synchronized void removePerfNotificationListener(NotificationListener listener) {
        try {
            this.timer.removeNotificationListener(listener);
            --this.perfTimerListeners;
            this.manageTimer();
        }
        catch (ListenerNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public synchronized boolean isStructuralUpdates() {
        return this.structuralTimerStarted;
    }

    @Override
    public synchronized void setStructuralUpdates(boolean value) {
        if (value == this.structuralTimerStarted) {
            return;
        }
        if (!this.structuralTimerStarted) {
            this.startStructuralUpdates();
        } else {
            this.stopStructuralUpdates();
        }
    }

    @Override
    public synchronized void startStructuralUpdates() {
        if (!this.structuralTimerStarted) {
            this.timer.addNotification("structTimer", null, null, new Date(System.currentTimeMillis()), this.structuralTimerPeriod);
            this.structuralTimerStarted = true;
        }
        this.manageTimer();
    }

    @Override
    public synchronized void stopStructuralUpdates() {
        if (this.structuralTimerStarted) {
            try {
                this.timer.removeNotifications("structTimer");
                this.structuralTimerStarted = false;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
        }
        this.manageTimer();
    }

    @Override
    public synchronized int getStructuraltimerPeriod() {
        return this.structuralTimerPeriod;
    }

    @Override
    public synchronized void setStructuraltimerPeriod(int structuralTimerPeriod) {
        if (structuralTimerPeriod != this.structuralTimerPeriod) {
            this.structuralTimerPeriod = structuralTimerPeriod;
            if (this.structuralTimerStarted) {
                this.stopStructuralUpdates();
                this.startStructuralUpdates();
            }
        }
    }

    public synchronized void addStructuralNotificationListener(NotificationListener listener, Object handback) {
        this.timer.addNotificationListener(listener, new NotificationFilter(){

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                return "structTimer".equals(notification.getType());
            }
        }, handback);
        ++this.structuralTimerListeners;
        this.manageTimer();
    }

    public synchronized void removeStructuralNotificationListener(NotificationListener listener) {
        try {
            this.timer.removeNotificationListener(listener);
            --this.structuralTimerListeners;
            this.manageTimer();
        }
        catch (ListenerNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private void killTimerOnExit() {
        this.timer.addNotification("isLastThreadTest", null, null, new Date(System.currentTimeMillis()), 1500L);
        this.timer.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                int dCount;
                ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
                int tCount = mbean.getThreadCount();
                if (tCount - (dCount = mbean.getDaemonThreadCount()) <= 2) {
                    Thread[] ts;
                    boolean stop = true;
                    while (Thread.enumerate(ts = new Thread[mbean.getThreadCount() + 3]) >= ts.length) {
                    }
                    for (Thread t : ts) {
                        if (t == null) break;
                        if (t.isDaemon() || t == Thread.currentThread() || t.getName().equals("DestroyJavaVM")) continue;
                        stop = false;
                    }
                    if (stop) {
                        MonitoringServices.this.timer.stop();
                    }
                }
            }
        }, new NotificationFilter(){

            @Override
            public boolean isNotificationEnabled(Notification notification) {
                return "isLastThreadTest".equals(notification.getType());
            }
        }, null);
    }
}

