/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import de.javakaffee.kryoserializers.guava.ImmutableListSerializer;
import de.javakaffee.kryoserializers.guava.ImmutableMapSerializer;
import java.util.Map;
import java.util.Set;

public class ImmutableMultimapSerializer
extends Serializer<ImmutableMultimap<Object, Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;

    public ImmutableMultimapSerializer() {
        super(true, true);
    }

    @Override
    public void write(Kryo kryo, Output output, ImmutableMultimap<Object, Object> immutableMultiMap) {
        kryo.writeObject(output, ImmutableMap.copyOf(immutableMultiMap.asMap()));
    }

    @Override
    public ImmutableMultimap<Object, Object> read(Kryo kryo, Input input, Class<ImmutableMultimap<Object, Object>> type) {
        Map map = kryo.readObject(input, ImmutableMap.class);
        Set entries = map.entrySet();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Map.Entry entry : entries) {
            builder.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.build();
    }

    public static void registerSerializers(Kryo kryo) {
        Serializer immutableMapSerializer;
        Serializer immutableListSerializer = kryo.getSerializer(ImmutableList.class);
        if (!(immutableListSerializer instanceof ImmutableListSerializer)) {
            ImmutableListSerializer.registerSerializers(kryo);
        }
        if (!((immutableMapSerializer = kryo.getSerializer(ImmutableMap.class)) instanceof ImmutableMapSerializer)) {
            ImmutableMapSerializer.registerSerializers(kryo);
        }
        ImmutableMultimapSerializer serializer = new ImmutableMultimapSerializer();
        kryo.register(ImmutableMultimap.class, serializer);
        kryo.register(ImmutableMultimap.of().getClass(), serializer);
        Object o = new Object();
        kryo.register(ImmutableMultimap.of(o, o).getClass(), serializer);
    }
}

