/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class CollectionsSetFromMapSerializer
extends Serializer<Set> {
    private static final Field mf;
    private static final Field sf;

    public CollectionsSetFromMapSerializer() {
        this.setImmutable(true);
    }

    @Override
    public void write(Kryo kryo, Output output, Set object) {
        try {
            kryo.writeClassAndObject(output, mf.get(object));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Set read(Kryo kryo, Input input, Class<Set> type) {
        try {
            Map m = (Map)kryo.readClassAndObject(input);
            Set s = Collections.newSetFromMap(Collections.EMPTY_MAP);
            mf.set(s, m);
            sf.set(s, m.keySet());
            return s;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            Class<?> cl = Collections.newSetFromMap(new HashMap()).getClass();
            mf = cl.getDeclaredField("m");
            mf.setAccessible(true);
            sf = cl.getDeclaredField("s");
            sf.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

