/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;

public class SimpleReservoir
implements Reservoir {
    private final LongAdder num = new LongAdder();
    private final LongAdder sum = new LongAdder();
    private final LongAccumulator max = new LongAccumulator(Math::max, 0L);
    private final LongAccumulator min = new LongAccumulator(Math::min, Long.MAX_VALUE);

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void update(long value) {
        this.num.increment();
        this.sum.add(value);
        this.max.accumulate(value);
        this.min.accumulate(value);
    }

    @Override
    public Snapshot getSnapshot() {
        return new Snapshot(){
            private final long num;
            private final long sum;
            private final long max;
            private final long min;
            {
                this.num = SimpleReservoir.this.num.sumThenReset();
                this.sum = SimpleReservoir.this.sum.sumThenReset();
                this.max = SimpleReservoir.this.max.getThenReset();
                this.min = SimpleReservoir.this.min.getThenReset();
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public long getMax() {
                return this.max;
            }

            @Override
            public long getMin() {
                return this.min;
            }

            @Override
            public double getMean() {
                return (double)this.sum / (double)this.num;
            }

            @Override
            public double getValue(double quantile) {
                if (quantile >= 1.0) {
                    return this.max;
                }
                if (quantile == 0.0) {
                    return this.min;
                }
                return -1.0;
            }

            @Override
            public long[] getValues() {
                return new long[]{this.min, this.max};
            }

            @Override
            public double getStdDev() {
                return 0.0;
            }

            @Override
            public void dump(OutputStream out) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }
}

