/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.servlet;

import co.paralleluniverse.fibers.servlet.FiberHttpServlet;
import co.paralleluniverse.fibers.servlet.FiberRequestDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FiberServletRequest
implements ServletRequest {
    private final ServletRequest req;
    private final ServletContext servletContext;
    private final FiberHttpServlet servlet;

    public FiberServletRequest(FiberHttpServlet servlet, ServletRequest req) {
        this.servlet = servlet;
        this.req = req;
        this.servletContext = req.getServletContext();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!this.servlet.disableSyncForward) {
            return new FiberRequestDispatcher(path, this.req.getAsyncContext());
        }
        return this.req.getRequestDispatcher(path);
    }

    ServletRequest getReq() {
        return this.req;
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.req.setCharacterEncoding(env);
    }

    public int getContentLength() {
        return this.req.getContentLength();
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.req.getInputStream();
    }

    public String getParameter(String name) {
        return this.req.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        return this.req.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.req.getParameterValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.req.getParameterMap();
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.req.getReader();
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.req.getLocales();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    @Deprecated
    public String getRealPath(String path) {
        return this.req.getRealPath(path);
    }

    public int getRemotePort() {
        return this.req.getRemotePort();
    }

    public String getLocalName() {
        return this.req.getLocalName();
    }

    public String getLocalAddr() {
        return this.req.getLocalAddr();
    }

    public int getLocalPort() {
        return this.req.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException("you can't use startAsync mechanism from fiber.servlet");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException("you can't use startAsync mechanism from fiber.servlet");
    }

    public boolean isAsyncStarted() {
        return this.req.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return this.req.getDispatcherType();
    }

    public int hashCode() {
        return this.req.hashCode();
    }

    public boolean equals(Object obj) {
        return this.req.equals(obj);
    }

    public String toString() {
        return this.req.toString();
    }
}

