/*
 * Decompiled with CFR 0.152.
 */
package cn.xuexi.open.utils;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class UriSignUtil {
    private static String getSignature(String stringToSign, String appSecret, boolean encode) {
        if (null == stringToSign || null == appSecret) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(appSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
            byte[] signatureBytes = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            String signature = Base64.getEncoder().encodeToString(signatureBytes);
            if (encode) {
                return URLEncoder.encode(signature);
            }
            return signature;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String checkSign(String path, String appSecret, String timestamp) {
        String stringToSign = path + "`" + timestamp;
        return UriSignUtil.getSignature(Hashing.sha256().hashString((CharSequence)stringToSign, Charsets.UTF_8).toString(), appSecret, true);
    }
}

