/*
 * Decompiled with CFR 0.152.
 */
package cn.xuexi.open.utils;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SHAUtils {
    public static final char[] DIGITAL = "0123456789ABCDEF".toCharArray();

    public static String getSignature(String stringToSign, String appSecret) {
        if (null == stringToSign || null == appSecret) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(appSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
            byte[] signatureBytes = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
            return SHAUtils.encodeHexStr(signatureBytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeHexStr(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] result = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            result[i * 2] = DIGITAL[(bytes[i] & 0xF0) >> 4];
            result[i * 2 + 1] = DIGITAL[bytes[i] & 0xF];
        }
        return new String(result);
    }

    public static String getSignatureContent(String urlPath, Map<String, String> params) {
        StringBuffer contentBuffer = new StringBuffer();
        contentBuffer.append(urlPath);
        ArrayList<String> paramValueList = new ArrayList<String>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramValueList.add(entry.getKey() + entry.getValue());
            }
        }
        Collections.sort(paramValueList);
        for (String aParamValueList : paramValueList) {
            contentBuffer.append(aParamValueList);
        }
        return contentBuffer.toString();
    }
}

