/*
 * Decompiled with CFR 0.152.
 */
package cn.xuexi.open.utils;

import cn.xuexi.open.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESUtils.class);
    private static final String AES_ALGORITHM = "AES/ECB/PKCS7Padding";

    private AESUtils() {
    }

    public static String encrypt(String content, String key) {
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        try {
            byte[] raw = key.getBytes();
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM, "BC");
            cipher.init(1, secretKeySpec);
            byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            return AESUtils.parseByte2HexStr(encrypted);
        }
        catch (Exception e) {
            logger.info("encrypt fail", (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String content, String key) {
        try {
            byte[] raw = key.getBytes();
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM, "BC");
            cipher.init(2, secretKeySpec);
            byte[] decrypted = AESUtils.parseHexStr2Byte(content);
            byte[] original = cipher.doFinal(decrypted);
            return new String(original, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.info("decrypt fail", (Throwable)e);
            return null;
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        return AESUtils.parseByte2HexStr(buf, true);
    }

    public static String parseByte2HexStr(byte[] buf, boolean upperCase) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            if (upperCase) {
                sb.append(hex.toUpperCase());
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (null == hexStr || hexStr.isEmpty()) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

