/*
 * Decompiled with CFR 0.152.
 */
package cn.xuexi.open.api;

import cn.xuexi.open.api.GateResponse;
import cn.xuexi.open.api.XuexiApiException;
import cn.xuexi.open.api.XuexiClient;
import cn.xuexi.open.api.XuexiClientConfig;
import cn.xuexi.open.api.XuexiRequest;
import cn.xuexi.open.api.XuexiResponse;
import cn.xuexi.open.utils.SHAUtils;
import cn.xuexi.open.utils.SnakeCaseObjectMapper;
import cn.xuexi.open.utils.StringUtils;
import cn.xuexi.open.utils.WebUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXuexiClient
implements XuexiClient {
    private Logger logger = LoggerFactory.getLogger(DefaultXuexiClient.class);
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String charset = "UTF-8";
    private String format = "json";
    private int connectTimeout = 5000;
    private int readTimeout = 15000;
    private SnakeCaseObjectMapper snakeCaseObjectMapper;

    public DefaultXuexiClient(XuexiClientConfig config) {
        this(config.getServerUrl(), config.getAppKey(), config.getAppSecret(), config.getFormat(), config.getCharset(), config.getReadTimeout(), config.getConnectTimeout());
    }

    public DefaultXuexiClient(String serverUrl, String appKey, String appSecret) {
        this(serverUrl, appKey, appSecret, null, null, 0, 0);
    }

    public DefaultXuexiClient(String serverUrl, String appKey, String appSecret, String format, String charset, int readTimeout, int connectTimeout) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.snakeCaseObjectMapper = new SnakeCaseObjectMapper();
        if (!StringUtils.isEmpty(format)) {
            this.format = format;
        }
        if (!StringUtils.isEmpty(charset)) {
            this.charset = charset;
        }
        if (readTimeout > 0) {
            this.readTimeout = readTimeout;
        }
        if (connectTimeout > 0) {
            this.connectTimeout = connectTimeout;
        }
    }

    @Override
    public XuexiResponse execute(XuexiRequest request) throws XuexiApiException {
        String version = StringUtils.isEmpty(request.getApiVersion()) ? "1" : request.getApiVersion();
        String group = StringUtils.isEmpty(request.getApiGroup()) ? "xuexi.open" : request.getApiGroup();
        String path = String.join((CharSequence)"/", "param2", version, group, request.getApiMethodName(), this.appKey);
        Map<String, String> params = request.getTextParams();
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("_aop_timestamp", String.valueOf(System.currentTimeMillis()));
        String originText = SHAUtils.getSignatureContent(path, params);
        String sign = SHAUtils.getSignature(originText, this.appSecret);
        params.put("_aop_signature", sign);
        StringBuilder urlBuilder = new StringBuilder(this.serverUrl);
        urlBuilder.append("/").append(path);
        String result = "";
        try {
            int currentReadTimeout = request.getReadTimeout() > 0 ? request.getReadTimeout() : this.readTimeout;
            int currentConnectTimeout = request.getConnectTimeout() > 0 ? request.getConnectTimeout() : this.connectTimeout;
            result = "post".equalsIgnoreCase(request.getHttpMethod()) ? WebUtils.doPost(urlBuilder.toString(), params, this.charset, currentReadTimeout, currentConnectTimeout, request.getCustomHeaders()) : WebUtils.doGet(urlBuilder.toString(), params, this.charset, currentReadTimeout, currentConnectTimeout, request.getCustomHeaders());
            JavaType javaType = this.snakeCaseObjectMapper.getTypeFactory().constructParametricType(GateResponse.class, new Class[]{request.getResponseClass()});
            GateResponse response = (GateResponse)this.snakeCaseObjectMapper.readValue(result, javaType);
            return response.getResponse();
        }
        catch (Exception e) {
            this.logger.error("http request exception, api method is {}", (Object)request.getApiMethodName(), (Object)e);
            throw new XuexiApiException(request.getApiMethodName() + " http request exception", e);
        }
    }

    @Override
    public XuexiResponse doExecute(String apiMethodName, String httpMethod, Map<String, String> requestParams, Map<String, String> headers, String apiGroup, String apiVersion) throws XuexiApiException {
        String version = StringUtils.isEmpty(apiVersion) ? "1" : apiVersion;
        String group = StringUtils.isEmpty(apiGroup) ? "xuexi.open" : apiGroup;
        String path = String.join((CharSequence)"/", "param2", version, group, apiMethodName, this.appKey);
        Map<String, String> params = requestParams;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("_aop_timestamp", String.valueOf(System.currentTimeMillis()));
        String originText = SHAUtils.getSignatureContent(path, params);
        String sign = SHAUtils.getSignature(originText, this.appSecret);
        params.put("_aop_signature", sign);
        StringBuilder urlBuilder = new StringBuilder(this.serverUrl);
        urlBuilder.append("/").append(path);
        String result = "";
        try {
            int currentReadTimeout = this.readTimeout;
            int currentConnectTimeout = this.connectTimeout;
            result = "post".equalsIgnoreCase(httpMethod) ? WebUtils.doPost(urlBuilder.toString(), params, this.charset, currentReadTimeout, currentConnectTimeout, headers) : WebUtils.doGet(urlBuilder.toString(), params, this.charset, currentReadTimeout, currentConnectTimeout, headers);
            JavaType javaType = this.snakeCaseObjectMapper.getTypeFactory().constructParametricType(GateResponse.class, new Class[]{JsonNode.class});
            GateResponse response = (GateResponse)this.snakeCaseObjectMapper.readValue(result, javaType);
            return response.getResponse();
        }
        catch (Exception e) {
            this.logger.error("http request exception, api method is {}", (Object)apiMethodName, (Object)e);
            throw new XuexiApiException(apiMethodName + " http request exception", e);
        }
    }

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

