/*
 * Decompiled with CFR 0.152.
 */
package cc.uccc.common.permission.interceptor;

import cc.uccc.common.permission.ErrorEnum;
import cc.uccc.common.permission.interceptor.AuthorizationException;
import cc.uccc.common.permission.service.IPermissionCheckService;
import com.uccc.rainbow.core.exception.RPCException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TokenPermissionInterceptor
implements HandlerInterceptor {
    private IPermissionCheckService permissionCheckService;
    private String servletPath;
    private boolean checkPermission = true;

    public TokenPermissionInterceptor(IPermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.trim().equals("")) {
            authHeader = request.getParameter("Authorization");
        }
        if (authHeader == null) {
            AuthorizationException exception = new AuthorizationException(ErrorEnum.INVALID_TOKEN.getCode(), ErrorEnum.INVALID_TOKEN.getReason());
            throw exception;
        }
        String uri = request.getRequestURI();
        if (this.servletPath != null) {
            uri = uri.replaceFirst(this.servletPath, "");
        }
        String method = request.getMethod().toLowerCase();
        String express = uri + ":" + method;
        try {
            if (this.checkPermission) {
                String userId = this.permissionCheckService.checkPermissionByToken(authHeader, express);
                request.setAttribute("userId", (Object)userId);
            } else {
                String userId = this.permissionCheckService.decodeToken(authHeader);
                request.setAttribute("userId", (Object)userId);
            }
        }
        catch (RPCException e) {
            throw new AuthorizationException(e.getCode(), e.getMessage());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setCheckPermission(boolean checkPermission) {
        this.checkPermission = checkPermission;
    }
}

