/*
 * Decompiled with CFR 0.152.
 */
package cc.uccc.common.permission.interceptor;

import cc.uccc.common.permission.ErrorEnum;
import cc.uccc.common.permission.interceptor.AuthorizationException;
import cc.uccc.common.permission.service.IPermissionCheckService;
import com.uccc.rainbow.core.exception.RPCException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class PermissionInterceptor
implements HandlerInterceptor {
    private IPermissionCheckService permissionCheckService;
    private String servletPath;

    public PermissionInterceptor(IPermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String uid = request.getHeader("uid");
        if (uid == null || uid.equals("")) {
            throw new AuthorizationException(ErrorEnum.INVALID_TOKEN.getCode(), ErrorEnum.INVALID_TOKEN.getReason());
        }
        String uri = request.getRequestURI();
        if (this.servletPath != null) {
            uri = uri.replaceFirst(this.servletPath, "");
        }
        String method = request.getMethod().toLowerCase();
        String express = uri + ":" + method;
        try {
            this.permissionCheckService.checkPermission(uid, express);
        }
        catch (RPCException e) {
            throw new AuthorizationException(e.getCode(), e.getMessage());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void setPermissionCheckService(IPermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }
}

