package cc.uccc.common.permission.service;

import cc.uccc.common.permission.model.PPermission;
import cc.uccc.common.permission.model.PRole;
import cc.uccc.common.permission.model.PUser;
import com.uccc.rainbow.annotation.RMethod;
import com.uccc.rainbow.annotation.RService;
import com.uccc.rainbow.core.exception.RPCException;

import java.util.List;

/**
 * Created by kidbei on 2016/11/1.
 */
@RService(name = "userService")
public interface IUserService {

    @RMethod
    void addUser(PUser PUser) throws RPCException;

    @RMethod
    void deleteUser(String userId) throws RPCException;

    @RMethod
    PUser getUser(String userId) throws RPCException;

    @RMethod
    void updateUser(PUser PUser) throws RPCException;

    @RMethod
    List<PPermission> findPermissions(String userId) throws RPCException;

    @RMethod
    void addRole(String userId,Long roleId) throws RPCException;

    @RMethod
    void addRoleByRoleName(String userId,String roleName) throws RPCException;

    @RMethod
    void deleteRole(String userId,Long roleId) throws RPCException;

    @RMethod
    List<PRole> findRoles(String userId) throws RPCException;

    @RMethod
    List<PUser> findUsers(List<String> userIds)  throws RPCException;
}
