package cc.uccc.common.permission.service;

import cc.uccc.common.permission.model.PPermission;
import cc.uccc.common.permission.model.PRole;
import cc.uccc.common.permission.model.PUser;
import com.uccc.rainbow.annotation.RMethod;
import com.uccc.rainbow.annotation.RService;
import com.uccc.rainbow.core.exception.RPCException;

import java.util.List;

/**
 * Created by kidbei on 2016/11/1.
 */
@RService(name = "roleService")
public interface IRoleService {

    @RMethod
    Long addRole(PRole PRole) throws RPCException;

    @RMethod
    PRole getRole(Long roleId) throws RPCException;

    @RMethod
    void  updateRole(PRole PRole) throws RPCException;

    @RMethod
    List<PPermission> findPermissions(Long roleId) throws RPCException;

    @RMethod
    void deleteRole(Long roleId) throws RPCException;

    @RMethod
    List<PRole> findAllRoles() throws RPCException;

    @RMethod
    void addPermission(Long roleId,Long permissionId) throws RPCException;

    @RMethod
    void addPermissionByRoleName(String name,Long permissionId) throws RPCException;

    @RMethod
    List<PUser> findUsers(Long roleId) throws RPCException;

    @RMethod
    void deletePermission(Long roleId,Long permissionId) throws RPCException;

    @RMethod
    List<PRole> findRoles(List<Long> roleIds) throws RPCException;
}
