package cc.uccc.common.permission.model;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by kidbei on 2016/11/2.
 */
@Entity
@Table(name = "uc_security_user_role",
    indexes = {
            @Index(name = "user_role_userId_idx",columnList = "userId"),
            @Index(name = "user_role_roleId_idx",columnList = "roleId")
    }
)
@NamedNativeQueries(
        {
                @NamedNativeQuery(
                        name = "UserRole.deleteByRoleId",
                        query = "DELETE FROM uc_security_user_role ur where ur.role_id = ?1"
                ),
                @NamedNativeQuery(
                        name = "UserRole.deleteByUserId",
                        query = "DELETE FROM uc_security_user_role ur where ur.user_id = ?1"
                )
        }
)
public class UserRole implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long roleId;
    private String userId;

    public UserRole(Long roleId, String userId) {
        this.roleId = roleId;
        this.userId = userId;
    }

    public UserRole() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
