package cc.uccc.common.permission.model;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by kidbei on 2016/11/1.
 */
@Entity
@Table(name = "uc_security_role_permission",
    indexes = {
            @Index(name = "role_permission_roleId_idx",columnList = "roleId"),
            @Index(name = "role_permission_permissionId_idx",columnList = "permissionId"),
    }
)
@NamedNativeQueries(
        {
                @NamedNativeQuery(
                        name = "RolePermission.deleteByRoleId",
                        query = "DELETE FROM uc_security_role_permission rp WHERE rp.role_id = ?1"
                ),
                @NamedNativeQuery(
                        name = "RolePermission.deleteByPermissionId",
                        query = "DELETE FROM uc_security_role_permission rp WHERE rp.permission_id = ?1"
                )
        }
)
public class RolePermission implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    private Long roleId;

    private Long permissionId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public Long getPermissionId() {
        return permissionId;
    }

    public void setPermissionId(Long permissionId) {
        this.permissionId = permissionId;
    }
}
