package cc.uccc.common.permission.model;

import cc.uccc.common.permission.jpa.JsonConverter;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Map;

/**
 * Created by kidbei on 2016/11/1.
 */
@Entity
@Table(name = "uc_security_user",
        indexes = {
                @Index(name = "user_id_idx",columnList = "userId")
        }
)
@NamedNativeQueries(
        {
                @NamedNativeQuery(
                        name = "PUser.findByRoleId",
                        query = "SELECT * FROM uc_security_user u,uc_security_user_role ur WHERE u.user_id = ur.user_id AND ur.role_id = ?1",
                        resultClass = PUser.class
                )
        }
)
public class PUser implements Serializable {

    @Id
    private String  userId;
    private String  password;
    private String  nickName;
    private Long    cts;

    @Convert(converter = JsonConverter.class)
    private Map<String,Object> customData;


    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getCts() {
        return cts;
    }

    public void setCts(Long cts) {
        this.cts = cts;
    }

    public Map<String, Object> getCustomData() {
        return customData;
    }

    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }
}
