package cc.uccc.common.permission.model;

import cc.uccc.common.permission.jpa.JsonConverter;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Map;

/**
 * 角色
 *
 * Created by kidbei on 2016/10/31.
 */
@Entity
@Table(name = "uc_security_role")
@NamedNativeQueries(
        {
                @NamedNativeQuery(
                        name = "PRole.findByUserId",
                        query = "SELECT r.* FROM uc_security_role r,uc_security_user_role ur WHERE r.id = ur.role_id AND ur.user_id = ?1 ",
                        resultClass = PRole.class
                )
        }
)
public class PRole implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long    id;
    private String  name;
    private String  description;
    private Long    cts;
    private Long    uts;

    @Convert(converter = JsonConverter.class)
    private Map<String,Object> customData;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getCts() {
        return cts;
    }

    public void setCts(Long cts) {
        this.cts = cts;
    }

    public Long getUts() {
        return uts;
    }

    public void setUts(Long uts) {
        this.uts = uts;
    }

    public Map<String, Object> getCustomData() {
        return customData;
    }

    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }
}
