package cc.uccc.common.permission.model;

import cc.uccc.common.permission.jpa.JsonConverter;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Map;

/**
 * Created by kidbei on 2016/10/31.
 */
@Entity
@Table(name = "uc_security_permission")
@NamedNativeQueries(
        {
                @NamedNativeQuery(
                        name = "PPermission.findByRoleId",
                        query = "SELECT p.* FROM uc_security_role_permission rp,uc_security_permission p WHERE rp.permission_id = p.id AND rp.role_id = ?1",
                        resultClass = PPermission.class
                ),
                @NamedNativeQuery(
                        name = "PPermission.deleteByRoleId",
                        query = "DELETE FROM uc_security_permission WHERE id IN (SELECT rp.permission_id FROM uc_security_role_permission rp WHERE  rp.role_id = ?1)"
                ),
                @NamedNativeQuery(
                        name = "PPermission.findByUserId",
                        query = "SELECT p.* FROM uc_security_permission p,uc_security_role_permission rp,uc_security_user_role ur WHERE p.id = rp.permission_id AND rp.role_id = ur.role_id AND ur.user_id = ?1",
                        resultClass = PPermission.class
                ),
                @NamedNativeQuery(
                        name = "PPermission.findExpressionByUserId",
                        query = "SELECT p.* " +
                                "FROM uc_security_permission p,uc_security_role_permission rp,uc_security_user_role ur " +
                                "WHERE p.id = rp.permission_id AND rp.role_id = ur.role_id AND ur.user_id = ?1",
                        resultClass = Expression.class
                )
        }
)
public class PPermission implements Serializable{

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long    id;
    private String  name;
    private String  description;
    private String  expression;
    private ExpType expType = ExpType.WILDCARD;
    private Long    cts;
    private Long    uts;

    @Convert(converter = JsonConverter.class)
    private Map<String,Object> customData;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExpression() {
        return expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public ExpType getExpType() {
        return expType;
    }

    public void setExpType(ExpType expType) {
        this.expType = expType;
    }

    public Long getCts() {
        return cts;
    }

    public void setCts(Long cts) {
        this.cts = cts;
    }

    public Long getUts() {
        return uts;
    }

    public void setUts(Long uts) {
        this.uts = uts;
    }

    public Map<String, Object> getCustomData() {
        return customData;
    }

    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }
}
