package cc.uccc.common.permission.model;

import com.uccc.cc.common.tree.core.TreeEntity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;

/**
 * 功能菜单。可以是一个菜单，能给这个菜单分配多个权限，作为一个权限的集合
 *
 * Created by kidbei on 2016/10/31.
 */
@Entity
@Table(name = "uc_security_function_node")
public class FunctionNode extends TreeEntity<Long> implements Serializable {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long    id;
    private String  name;
    private String  description;
    private String  path;
    private Long    cts;
    private Long    uts;

    @Transient
    private List<PPermission> PPermissions;

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Long getId() {
        return id;
    }


    public Long getCts() {
        return cts;
    }

    public void setCts(Long cts) {
        this.cts = cts;
    }

    public Long getUts() {
        return uts;
    }

    public void setUts(Long uts) {
        this.uts = uts;
    }

    public List<PPermission> getPPermissions() {
        return PPermissions;
    }

    public void setPPermissions(List<PPermission> PPermissions) {
        this.PPermissions = PPermissions;
    }
}
