package cc.uccc.common.permission.jpa;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import javax.persistence.AttributeConverter;
import javax.persistence.Convert;
import java.util.Map;

/**
 * Created by kidbei on 16/8/4.
 */
@Convert
public class JsonConverter implements AttributeConverter<Map<String,Object>,String> {


    @Override
    public String convertToDatabaseColumn(Map<String, Object> stringObjectMap) {
        if (stringObjectMap != null && !stringObjectMap.isEmpty()) {
            return JSONObject.toJSONString(stringObjectMap);
        }

        return null;
    }

    @Override
    public Map<String, Object> convertToEntityAttribute(String s) {
        if (s != null && !s.isEmpty()) {
            return JSONObject.toJavaObject(JSON.parseObject(s),Map.class);
        }
        return null;
    }
}
