package cc.uccc.common.permission.interceptor;

import cc.uccc.common.permission.ErrorEnum;
import cc.uccc.common.permission.service.IPermissionCheckService;
import com.uccc.rainbow.core.exception.RPCException;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by kidbei on 2016/11/3.
 */
public class TokenPermissionInterceptor implements HandlerInterceptor {



    private IPermissionCheckService permissionCheckService;
    private String servletPath;
    private boolean checkPermission = true;

    public TokenPermissionInterceptor(IPermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {

        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || authHeader.trim().equals("")) {
            authHeader = request.getParameter("Authorization");
        }
        if (authHeader == null) {
//            log.warn("Authorization header not found,uri={}",request.getRequestURI());
            AuthorizationException exception = new AuthorizationException(ErrorEnum.INVALID_TOKEN.getCode(),ErrorEnum.INVALID_TOKEN.getReason());
            throw exception;
        }

        String uri = request.getRequestURI();
        if (servletPath != null) {
            uri = uri.replaceFirst(servletPath,"");
        }
        String method = request.getMethod().toLowerCase();

        String express = uri + ":" + method;

        try{
            if (checkPermission) {
                String userId = permissionCheckService.checkPermissionByToken(authHeader,express);
//                if (log.isDebugEnabled()) {
//                    log.debug("request is auth success,uri={}",request.getRequestURI());
//                }
                request.setAttribute("userId",userId);
            } else {
                String userId = permissionCheckService.decodeToken(authHeader);
                request.setAttribute("userId",userId);
            }
        } catch(RPCException e) {
            throw new AuthorizationException(e.getCode(),e.getMessage());
        }

        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView)
            throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
            throws Exception {

    }


    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setCheckPermission(boolean checkPermission) {
        this.checkPermission = checkPermission;
    }
}
