package cc.uccc.common.permission.interceptor;

import cc.uccc.common.permission.ErrorEnum;
import cc.uccc.common.permission.service.IPermissionCheckService;
import com.uccc.rainbow.core.exception.RPCException;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by kidbei on 2016/11/2.
 */
public class PermissionInterceptor implements HandlerInterceptor {

    private IPermissionCheckService permissionCheckService;
    private String servletPath;



    public PermissionInterceptor(IPermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        String uid = request.getHeader("uid");
        if (uid == null || uid.equals("")) throw new AuthorizationException(ErrorEnum.INVALID_TOKEN.getCode(),ErrorEnum.INVALID_TOKEN.getReason());

        String uri = request.getRequestURI();
        if (servletPath != null) {
            uri = uri.replaceFirst(servletPath,"");
        }
        String method = request.getMethod().toLowerCase();

        String express = uri + ":" + method;

        try{
            permissionCheckService.checkPermission(uid,express);
        } catch(RPCException e) {
            throw new AuthorizationException(e.getCode(),e.getMessage());
        }

        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView)
            throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
            throws Exception {

    }


    public void setPermissionCheckService(IPermissionCheckService permissionCheckService) {
        this.permissionCheckService = permissionCheckService;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }
}
