package cc.uccc.common.permission.interceptor;

/**
 * Created by kidbei on 16/8/10.
 */
public class AuthorizationException extends RuntimeException {

    private String message;
    private Throwable throwable;
    private int code;


    public AuthorizationException(String message) {
        super(message);
        this.message = message;
    }


    public AuthorizationException(String message, Throwable throwable) {
        super(message,throwable);
        this.message = message;
        this.throwable = throwable;
    }

    public AuthorizationException(int code, String message) {
        super(message);
        this.code = code;
        this.message = message;
    }


    @Override
    public String getMessage() {
        return message;
    }

    public Throwable getThrowable() {
        return throwable;
    }

    public int getCode() {
        return code;
    }

    public AuthorizationException setCode(int code) {
        this.code = code;
        return this;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("AuthorizationException{");
        sb.append("message='").append(message).append('\'');
        sb.append(", throwable=").append(throwable);
        sb.append(", code='").append(code).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
